/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client;

import com.alibaba.csp.sentinel.cluster.client.ClusterTokenClient;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiLoader;

public final class TokenClientProvider {
    private static ClusterTokenClient client = null;

    public static ClusterTokenClient getClient() {
        return client;
    }

    private static void resolveTokenClientInstance() {
        ClusterTokenClient resolvedClient = SpiLoader.of(ClusterTokenClient.class).loadFirstInstance();
        if (resolvedClient == null) {
            RecordLog.info("[TokenClientProvider] No existing cluster token client, cluster client mode will not be activated", new Object[0]);
        } else {
            client = resolvedClient;
            RecordLog.info("[TokenClientProvider] Cluster token client resolved: {}", client.getClass().getCanonicalName());
        }
    }

    public static boolean isClientSpiAvailable() {
        return TokenClientProvider.getClient() != null;
    }

    private TokenClientProvider() {
    }

    static {
        TokenClientProvider.resolveTokenClientInstance();
    }
}

