/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.eagleeye;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class FastDateFormat {
    private final SimpleDateFormat fmt = this.createSimpleDateFormat();
    private char[] buffer = new char[23];
    private long lastSecond = -1L;
    private long lastMillis = -1L;

    FastDateFormat() {
    }

    public String format(long timestamp) {
        this.formatToBuffer(timestamp);
        return new String(this.buffer, 0, 23);
    }

    public String format(Date date) {
        return this.format(date.getTime());
    }

    public void formatAndAppendTo(long timestamp, StringBuilder appender) {
        this.formatToBuffer(timestamp);
        appender.append(this.buffer, 0, 23);
    }

    private void formatToBuffer(long timestamp) {
        if (timestamp == this.lastMillis) {
            return;
        }
        long diff = timestamp - this.lastSecond;
        if (diff >= 0L && diff < 1000L) {
            int ms = (int)(timestamp % 1000L);
            this.buffer[22] = (char)(ms % 10 + 48);
            this.buffer[21] = (char)((ms /= 10) % 10 + 48);
            this.buffer[20] = (char)(ms / 10 + 48);
            this.lastMillis = timestamp;
        } else {
            String result = this.fmt.format(new Date(timestamp));
            result.getChars(0, result.length(), this.buffer, 0);
            this.lastSecond = timestamp / 1000L * 1000L;
            this.lastMillis = timestamp;
        }
    }

    String formatWithoutMs(long timestamp) {
        long diff = timestamp - this.lastSecond;
        if (diff < 0L || diff >= 1000L) {
            String result = this.fmt.format(new Date(timestamp));
            result.getChars(0, result.length(), this.buffer, 0);
            this.lastSecond = timestamp / 1000L * 1000L;
            this.lastMillis = timestamp;
        }
        return new String(this.buffer, 0, 19);
    }

    private SimpleDateFormat createSimpleDateFormat() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        fmt.setTimeZone(TimeZone.getDefault());
        return fmt;
    }
}

