/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.plugin.websocket;

import java.util.function.Supplier;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.websocket.WebSocketPlugin;
import org.apache.shenyu.plugin.websocket.context.WebSocketShenyuContextDecorator;
import org.apache.shenyu.plugin.websocket.handler.WebSocketPluginDataHandler;
import org.apache.shenyu.plugin.websocket.handler.WebSocketUpstreamDataHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.http.websocket.WebsocketSpec;

@Configuration
@ConditionalOnProperty(value={"shenyu.plugins.websocket.enabled"}, havingValue="true", matchIfMissing=true)
public class WebSocketPluginConfiguration {
    @Bean
    public PluginDataHandler websocketPluginDataHandler() {
        return new WebSocketPluginDataHandler();
    }

    @Bean
    public WebSocketPlugin webSocketPlugin(WebSocketClient webSocketClient, WebSocketService webSocketService) {
        return new WebSocketPlugin(webSocketClient, webSocketService);
    }

    @Bean
    public ReactorNettyWebSocketClient reactorNettyWebSocketClient(ShenyuConfig shenyuConfig, ObjectProvider<HttpClient> httpClient) {
        WebsocketSpec.Builder builder = ((WebsocketClientSpec.Builder)WebsocketClientSpec.builder().maxFramePayloadLength(shenyuConfig.getWebsocket().getMaxFramePayloadSize() * 0x100000)).handlePing(shenyuConfig.getWebsocket().getEnableProxyPing().booleanValue());
        return new ReactorNettyWebSocketClient((HttpClient)httpClient.getIfAvailable(HttpClient::create), (Supplier)builder);
    }

    @Bean
    public WebSocketService webSocketService() {
        return new HandshakeWebSocketService();
    }

    @Bean
    public DiscoveryUpstreamDataHandler webSocketUpstreamDataHandler() {
        return new WebSocketUpstreamDataHandler();
    }

    @Bean
    public ShenyuContextDecorator webSocketShenyuContextDecorator() {
        return new WebSocketShenyuContextDecorator();
    }
}

