/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.closable.Closable;
import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RpcStats {
    private static final String SEPERATOR_METHOD_AND_PARAM = "|";
    private static ConcurrentHashMap<String, StatInfo> serviceStat = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, StatInfo>> methodStat = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);

    public static void beforeCall(URL url, Request request) {
        String uri = url.getUri();
        RpcStats.onBeforeCall(RpcStats.getServiceStat(uri));
        RpcStats.onBeforeCall(RpcStats.getMethodStat(uri, request.getMethodName(), request.getParamtersDesc()));
    }

    public static void afterCall(URL url, Request request, boolean success, long procTimeMills) {
        String uri = url.getUri();
        RpcStats.onAfterCall(RpcStats.getServiceStat(uri), success, procTimeMills);
        RpcStats.onAfterCall(RpcStats.getMethodStat(uri, request.getMethodName(), request.getParamtersDesc()), success, procTimeMills);
    }

    public static StatInfo getServiceStat(URL url) {
        return RpcStats.getServiceStat(url.getUri());
    }

    public static StatInfo getMethodStat(URL url, Request request) {
        return RpcStats.getMethodStat(url.getUri(), request.getMethodName(), request.getParamtersDesc());
    }

    private static StatInfo getServiceStat(String uri) {
        StatInfo stat = serviceStat.get(uri);
        if (stat == null) {
            stat = new StatInfo();
            serviceStat.putIfAbsent(uri, stat);
            stat = serviceStat.get(uri);
        }
        return stat;
    }

    private static StatInfo getMethodStat(String uri, String methodName, String methodParaDesc) {
        String methodNameAndParams;
        StatInfo mstat;
        ConcurrentHashMap<String, StatInfo> sstats = methodStat.get(uri);
        if (sstats == null) {
            sstats = new ConcurrentHashMap();
            methodStat.putIfAbsent(uri, sstats);
            sstats = methodStat.get(uri);
        }
        if ((mstat = sstats.get(methodNameAndParams = methodName + SEPERATOR_METHOD_AND_PARAM + methodParaDesc)) == null) {
            mstat = new StatInfo();
            sstats.putIfAbsent(methodNameAndParams, mstat);
            mstat = sstats.get(methodNameAndParams);
        }
        return mstat;
    }

    private static void onBeforeCall(StatInfo statInfo) {
        statInfo.activeCount.incrementAndGet();
    }

    private static void onAfterCall(StatInfo statInfo, boolean success, long procTimeMills) {
        statInfo.activeCount.decrementAndGet();
        if (!success) {
            statInfo.failCount.incrementAndGet();
        }
        statInfo.totalCountTime.inc(1, procTimeMills);
        statInfo.latestCountTime.inc(1, procTimeMills);
    }

    private static void startCleaner() {
    }

    private static void cleanLatestStat() {
        if (serviceStat.size() == 0) {
            return;
        }
        for (StatInfo si : serviceStat.values()) {
            si.resetLatestStat();
        }
    }

    static {
        ShutDownHook.registerShutdownHook(new Closable(){

            @Override
            public void close() {
                if (!scheduledExecutor.isShutdown()) {
                    scheduledExecutor.shutdown();
                }
            }
        });
    }

    public static class CountTime {
        private AtomicLong count = new AtomicLong();
        private AtomicLong timeMills = new AtomicLong();

        private void inc(int incCount, long incTimeMills) {
            this.count.getAndAdd(incCount);
            this.timeMills.getAndAdd(incTimeMills);
        }

        public long getCount() {
            return this.count.get();
        }

        public void reset() {
            this.count.set(0L);
            this.timeMills.set(0L);
        }
    }

    public static class StatInfo {
        private AtomicInteger activeCount = new AtomicInteger();
        private AtomicLong failCount = new AtomicLong();
        private CountTime totalCountTime = new CountTime();
        private CountTime latestCountTime = new CountTime();

        public int getActiveCount() {
            return this.activeCount.get();
        }

        public long getFailCount() {
            return this.failCount.get();
        }

        public CountTime getTotalCountTime() {
            return this.totalCountTime;
        }

        public CountTime getLatestCountTime() {
            return this.latestCountTime;
        }

        public void resetLatestStat() {
            this.latestCountTime.reset();
        }
    }
}

