/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import io.grpc.Internal;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerProvider;
import io.grpc.okhttp.OkHttpServerBuilder;
import java.net.InetSocketAddress;

@Internal
public final class OkHttpServerProvider
extends ServerProvider {
    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }

    protected OkHttpServerBuilder builderForPort(int port) {
        throw new UnsupportedOperationException("Use Grpc.newServerBuilderForPort() instead");
    }

    protected ServerProvider.NewServerBuilderResult newServerBuilderForPort(int port, ServerCredentials creds) {
        OkHttpServerBuilder.HandshakerSocketFactoryResult result = OkHttpServerBuilder.handshakerSocketFactoryFrom(creds);
        if (result.error != null) {
            return ServerProvider.NewServerBuilderResult.error((String)result.error);
        }
        return ServerProvider.NewServerBuilderResult.serverBuilder((ServerBuilder)new OkHttpServerBuilder(new InetSocketAddress(port), result.factory));
    }
}

