/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ParameterFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterFormatter.class);

    public static JsonElement tryParseJsonString(String jsonString) {
        if (!StringUtils.hasText((String)jsonString)) {
            return new JsonPrimitive(Objects.isNull(jsonString) ? "" : jsonString);
        }
        String trimmed = jsonString.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]") || trimmed.startsWith("{") && trimmed.endsWith("}")) {
            try {
                return (JsonElement)GsonUtils.getInstance().fromJson(jsonString, JsonElement.class);
            }
            catch (Exception e) {
                LOG.debug("Failed to parse JSON string, keeping as string: {}", (Object)e.getMessage());
            }
        }
        return new JsonPrimitive(jsonString);
    }
}

