/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.protocol.tars;

import com.qq.tars.common.util.BeanAccessor;
import com.qq.tars.common.util.CollectionUtils;
import com.qq.tars.common.util.CommonUtils;
import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.exc.TarsDecodeException;
import com.qq.tars.protocol.tars.support.TarsStructInfo;
import com.qq.tars.protocol.tars.support.TarsStrutPropertyInfo;
import com.qq.tars.protocol.util.TarsHelper;
import java.util.List;

public class TarsInputStreamExt {
    public static <T> T read(T e, int tag, boolean isRequire, TarsInputStream jis) {
        TarsStructInfo info = TarsHelper.getStructInfo(e.getClass());
        if (info == null) {
            throw new TarsDecodeException("the JavaBean[" + e.getClass().getSimpleName() + "] no annotation Struct");
        }
        if (jis.skipToTag(tag)) {
            TarsInputStream.HeadData hd = new TarsInputStream.HeadData();
            jis.readHead(hd);
            if (hd.type != 10) {
                throw new TarsDecodeException("type mismatch.");
            }
            Object result = CommonUtils.newInstance(e.getClass());
            List<TarsStrutPropertyInfo> list = info.getPropertyList();
            if (CollectionUtils.isNotEmpty(list)) {
                for (TarsStrutPropertyInfo propertyInfo : list) {
                    Object value = jis.read(propertyInfo.getStamp(), propertyInfo.getOrder(), propertyInfo.isRequire());
                    BeanAccessor.setBeanValue(result, propertyInfo.getName(), value);
                }
            }
            jis.skipToStructEnd();
            return result;
        }
        if (isRequire) {
            throw new TarsDecodeException("require field not exist.");
        }
        return null;
    }
}

