/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.common.support;

import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import com.qq.tars.rpc.common.Url;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractInvoker<T>
implements Invoker<T> {
    private final Url url;
    private final Class<T> api;
    private volatile AtomicBoolean available = new AtomicBoolean(true);
    private volatile boolean destroyed = false;

    public AbstractInvoker(Class<T> api, Url url) {
        if (api == null || url == null) {
            throw new IllegalArgumentException();
        }
        this.api = api;
        this.url = url;
    }

    @Override
    public Class<T> getApi() {
        return this.api;
    }

    @Override
    public Url getUrl() {
        return this.url;
    }

    @Override
    public boolean isAvailable() {
        return !this.isDestroyed() && this.available.get();
    }

    protected void setAvailable(boolean available) {
        this.available.set(available);
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        this.destroyed = true;
        this.setAvailable(false);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        return this.getUrl().toIdentityString();
    }

    @Override
    public Object invoke(InvokeContext context) throws Throwable {
        if (this.destroyed) {
            throw new RuntimeException("invoker for " + this + " is destroyed!");
        }
        context.setInvoker(this);
        return this.doInvoke(context);
    }

    protected abstract Object doInvoke(InvokeContext var1) throws Throwable;
}

