/*
 * Decompiled with CFR 0.152.
 */
package io.fury.type;

import io.fury.type.Descriptor;
import io.fury.type.TypeUtils;
import io.fury.util.record.RecordUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;

public class DescriptorGrouper {
    private static final Comparator<Descriptor> PRIMITIVE_COMPARATOR = (d1, d2) -> {
        int c = TypeUtils.getSizeOfPrimitiveType(TypeUtils.unwrap(d2.getRawType())) - TypeUtils.getSizeOfPrimitiveType(TypeUtils.unwrap(d1.getRawType()));
        if (c == 0) {
            c = COMPARATOR_BY_TYPE_AND_NAME.compare((Descriptor)d1, (Descriptor)d2);
        }
        return c;
    };
    public static final Comparator<Descriptor> COMPARATOR_BY_TYPE_AND_NAME = (d1, d2) -> {
        int c = d1.getRawType().getName().compareTo(d2.getRawType().getName());
        if (c == 0 && (c = d1.getName().compareTo(d2.getName())) == 0) {
            c = d1.getDeclaringClass().compareTo(d2.getDeclaringClass());
        }
        return c;
    };
    private final Collection<Descriptor> primitiveDescriptors;
    private final Collection<Descriptor> boxedDescriptors;
    private final Collection<Descriptor> collectionDescriptors;
    private final Collection<Descriptor> mapDescriptors;
    private final Collection<Descriptor> finalDescriptors;
    private final Collection<Descriptor> otherDescriptors;

    public static Comparator<Descriptor> getPrimitiveComparator(boolean compressInt, boolean compressLong) {
        if (!compressInt && !compressLong) {
            return PRIMITIVE_COMPARATOR;
        }
        return (d1, d2) -> {
            Class<?> t1 = TypeUtils.unwrap(d1.getRawType());
            Class<?> t2 = TypeUtils.unwrap(d2.getRawType());
            boolean t1Compress = DescriptorGrouper.isCompressedType(t1, compressInt, compressLong);
            boolean t2Compress = DescriptorGrouper.isCompressedType(t2, compressInt, compressLong);
            if (t1Compress && t2Compress || !t1Compress && !t2Compress) {
                int c = TypeUtils.getSizeOfPrimitiveType(t2) - TypeUtils.getSizeOfPrimitiveType(t1);
                if (c == 0) {
                    c = COMPARATOR_BY_TYPE_AND_NAME.compare((Descriptor)d1, (Descriptor)d2);
                }
                return c;
            }
            if (t1Compress) {
                return 1;
            }
            return -1;
        };
    }

    private static boolean isCompressedType(Class<?> cls, boolean compressInt, boolean compressLong) {
        if ((cls = TypeUtils.unwrap(cls)) == Integer.TYPE) {
            return compressInt;
        }
        if (cls == Long.TYPE) {
            return compressLong;
        }
        return false;
    }

    public DescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, Function<Descriptor, Descriptor> descriptorUpdator, Comparator<Descriptor> primitiveComparator, Comparator<Descriptor> comparator) {
        this.primitiveDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(primitiveComparator);
        this.boxedDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(primitiveComparator);
        this.collectionDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.mapDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.finalDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.otherDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        for (Descriptor descriptor : descriptors) {
            if (descriptor.getRawType().isPrimitive()) {
                this.primitiveDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (TypeUtils.isBoxed(descriptor.getRawType())) {
                this.boxedDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (TypeUtils.isCollection(descriptor.getRawType())) {
                this.collectionDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (TypeUtils.isMap(descriptor.getRawType())) {
                this.mapDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            if (Modifier.isFinal(descriptor.getRawType().getModifiers())) {
                this.finalDescriptors.add(descriptorUpdator.apply(descriptor));
                continue;
            }
            this.otherDescriptors.add(descriptorUpdator.apply(descriptor));
        }
    }

    public List<Descriptor> getSortedDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(this.getNumDescriptors());
        descriptors.addAll(this.getPrimitiveDescriptors());
        descriptors.addAll(this.getBoxedDescriptors());
        descriptors.addAll(this.getFinalDescriptors());
        descriptors.addAll(this.getCollectionDescriptors());
        descriptors.addAll(this.getMapDescriptors());
        descriptors.addAll(this.getOtherDescriptors());
        return descriptors;
    }

    public Collection<Descriptor> getPrimitiveDescriptors() {
        return this.primitiveDescriptors;
    }

    public Collection<Descriptor> getBoxedDescriptors() {
        return this.boxedDescriptors;
    }

    public Collection<Descriptor> getCollectionDescriptors() {
        return this.collectionDescriptors;
    }

    public Collection<Descriptor> getMapDescriptors() {
        return this.mapDescriptors;
    }

    public Collection<Descriptor> getFinalDescriptors() {
        return this.finalDescriptors;
    }

    public Collection<Descriptor> getOtherDescriptors() {
        return this.otherDescriptors;
    }

    private static Descriptor createDescriptor(Descriptor d) {
        Method readMethod = d.getReadMethod();
        if (readMethod != null && !RecordUtils.isRecord(readMethod.getDeclaringClass())) {
            readMethod = null;
        }
        if (readMethod == null && d.getWriteMethod() == null) {
            return d;
        }
        return d.copy(d.getTypeToken(), readMethod, null);
    }

    public static DescriptorGrouper createDescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, boolean compressInt, boolean compressLong) {
        Comparator<Descriptor> comparator = DescriptorGrouper.getPrimitiveComparator(compressInt, compressLong);
        return new DescriptorGrouper(descriptors, descriptorsGroupedOrdered, DescriptorGrouper::createDescriptor, comparator, COMPARATOR_BY_TYPE_AND_NAME);
    }

    public int getNumDescriptors() {
        return this.primitiveDescriptors.size() + this.boxedDescriptors.size() + this.collectionDescriptors.size() + this.mapDescriptors.size() + this.finalDescriptors.size() + this.otherDescriptors.size();
    }
}

