/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.breeze.serializer;

import com.weibo.breeze.BreezeBuffer;
import com.weibo.breeze.BreezeException;
import com.weibo.breeze.BreezeReader;
import com.weibo.breeze.BreezeWriter;
import com.weibo.breeze.serializer.Serializer;
import com.weibo.breeze.type.Types;
import java.sql.Timestamp;

public class TimestampSerializer
implements Serializer<Timestamp> {
    private static final String[] names = new String[]{Timestamp.class.getName()};

    @Override
    public void writeToBuf(Timestamp obj, BreezeBuffer buffer) throws BreezeException {
        BreezeWriter.writeMessage(buffer, () -> Types.TYPE_INT64.writeMessageField(buffer, 1, obj.getTime()));
    }

    @Override
    public Timestamp readFromBuf(BreezeBuffer buffer) throws BreezeException {
        Timestamp timestamp = new Timestamp(0L);
        BreezeReader.readMessage(buffer, index -> {
            switch (index) {
                case 1: {
                    timestamp.setTime((Long)Types.TYPE_INT64.read(buffer));
                }
            }
        });
        return timestamp;
    }

    @Override
    public String[] getNames() {
        return names;
    }
}

