/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.internals;

import com.google.common.math.LongMath;
import com.huaweicloud.lts.producer.Attempt;
import com.huaweicloud.lts.producer.ProducerConfig;
import com.huaweicloud.lts.producer.exception.LogException;
import com.huaweicloud.lts.producer.exception.RetriableErrors;
import com.huaweicloud.lts.producer.http.Client;
import com.huaweicloud.lts.producer.internals.ProducerBatch;
import com.huaweicloud.lts.producer.internals.RetryQueue;
import com.huaweicloud.lts.producer.model.log.PutLogsRequest;
import com.huaweicloud.lts.producer.model.log.PutLogsResponse;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProducerBatchTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBatch.class);
    private final ProducerBatch batch;
    private final ProducerConfig producerConfig;
    private final Map<String, Client> clientPool;
    private final RetryQueue retryQueue;
    private final BlockingQueue<ProducerBatch> successQueue;
    private final BlockingQueue<ProducerBatch> failureQueue;
    private final AtomicInteger batchCount;

    public SendProducerBatchTask(ProducerBatch batch, ProducerConfig producerConfig, Map<String, Client> clientPool, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, AtomicInteger batchCount) {
        this.batch = batch;
        this.producerConfig = producerConfig;
        this.clientPool = clientPool;
        this.retryQueue = retryQueue;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.batchCount = batchCount;
    }

    @Override
    public void run() {
        try {
            this.sendProducerBatch(System.currentTimeMillis());
        }
        catch (Throwable t) {
            LOGGER.error("Uncaught error in send producer batch task, logGroupId=" + this.batch.getLogGroupId() + ", logStreamId=" + this.batch.getLogStreamId() + ", e=", t);
        }
    }

    private void sendProducerBatch(long nowMs) throws InterruptedException {
        LOGGER.trace("Prepare to send producer batch, batch={}", (Object)this.batch);
        Client client = this.getClient(this.producerConfig.getProjectId());
        if (client == null) {
            LOGGER.error("Failed to get client, project={}", (Object)this.producerConfig.getProjectId());
            Attempt attempt = new Attempt(false, "", "ProjectConfigNotExist", "Cannot get the projectConfig for project " + this.producerConfig.getProjectId(), nowMs);
            this.batch.appendAttempt(attempt);
            this.failureQueue.put(this.batch);
        } else {
            PutLogsResponse response;
            try {
                PutLogsRequest request = this.buildPutLogsRequest(this.batch);
                response = client.PutLogs(request);
            }
            catch (Exception e) {
                block8: {
                    LOGGER.error("Failed to put logs, logGroupId=" + this.batch.getLogGroupId() + ", logStreamId=" + this.batch.getLogStreamId() + ", e=", (Throwable)e);
                    Attempt attempt = this.buildAttempt(e, nowMs);
                    this.batch.appendAttempt(attempt);
                    if (this.meetFailureCondition(e)) {
                        LOGGER.debug("Prepare to put batch to the failure queue");
                        this.failureQueue.put(this.batch);
                    } else {
                        LOGGER.debug("Prepare to put batch to the retry queue");
                        long retryBackoffMs = this.calculateRetryBackoffMs();
                        LOGGER.debug("Calculate the retryBackoffMs successfully, retryBackoffMs=" + retryBackoffMs);
                        this.batch.setNextRetryMs(System.currentTimeMillis() + retryBackoffMs);
                        try {
                            this.retryQueue.put(this.batch);
                        }
                        catch (IllegalStateException e1) {
                            LOGGER.error("Failed to put batch to the retry queue logGroupId=" + this.batch.getLogGroupId() + ", logStreamId=" + this.batch.getLogStreamId() + ", e=", (Throwable)e);
                            if (!this.retryQueue.isClosed()) break block8;
                            LOGGER.info("Prepare to put batch to the failure queue since the retry queue was closed");
                            this.failureQueue.put(this.batch);
                        }
                    }
                }
                return;
            }
            Attempt attempt = new Attempt(true, response.GetRequestId(), "", "", nowMs);
            this.batch.appendAttempt(attempt);
            this.successQueue.put(this.batch);
            LOGGER.trace("Send producer batch successfully, batch={}", (Object)this.batch);
        }
    }

    private Client getClient(String project) {
        return this.clientPool.get(project);
    }

    private PutLogsRequest buildPutLogsRequest(ProducerBatch batch) {
        PutLogsRequest request = new PutLogsRequest(batch.getLogGroupId(), batch.getLogStreamId(), batch.getLogItems(), batch.getAppName(), batch.getPathFile(), this.producerConfig.isLogBackSdk(), this.producerConfig.isEnableLocalTest());
        request.setContentType("application/json");
        return request;
    }

    private Attempt buildAttempt(Exception e, long nowMs) {
        if (e instanceof LogException) {
            LogException logException = (LogException)e;
            return new Attempt(false, logException.GetRequestId(), logException.GetErrorCode(), logException.GetErrorMessage(), nowMs);
        }
        return new Attempt(false, "", "ProducerException", e.getMessage(), nowMs);
    }

    private boolean meetFailureCondition(Exception e) {
        if (!this.isRetriableException(e)) {
            return true;
        }
        if (this.retryQueue.isClosed()) {
            return true;
        }
        return this.batch.getRetries() >= this.producerConfig.getRetries() && this.failureQueue.size() <= this.batchCount.get() / 2;
    }

    private boolean isRetriableException(Exception e) {
        if (e instanceof LogException) {
            LogException logException = (LogException)e;
            return RetriableErrors.RETRY_ERRORS_LIST.contains(logException.GetErrorCode());
        }
        return false;
    }

    private long calculateRetryBackoffMs() {
        int retry = this.batch.getRetries();
        long retryBackoffMs = this.producerConfig.getBaseRetryBackoffMs() * LongMath.pow((long)2L, (int)retry);
        if (retryBackoffMs <= 0L) {
            retryBackoffMs = this.producerConfig.getMaxRetryBackoffMs();
        }
        return Math.min(retryBackoffMs, this.producerConfig.getMaxRetryBackoffMs());
    }
}

