/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.utils;

public class ByteArrayUtils {
    public static int indexOf(byte[] org, byte[] search) {
        return ByteArrayUtils.indexOf(org, search, 0);
    }

    public static int indexOf(byte[] org, byte[] search, int startIndex) {
        KMPMatcher kmpMatcher = new KMPMatcher();
        kmpMatcher.computeFailure4Byte(search);
        return kmpMatcher.indexOf(org, startIndex);
    }

    static class KMPMatcher {
        private int[] failure;
        private int matchPoint;
        private byte[] bytePattern;

        KMPMatcher() {
        }

        public int indexOf(byte[] text, int startIndex) {
            int j = 0;
            if (text.length == 0 || startIndex > text.length) {
                return -1;
            }
            for (int i = startIndex; i < text.length; ++i) {
                while (j > 0 && this.bytePattern[j] != text[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == text[i]) {
                    ++j;
                }
                if (j != this.bytePattern.length) continue;
                this.matchPoint = i - this.bytePattern.length + 1;
                return this.matchPoint;
            }
            return -1;
        }

        public int lastIndexOf(byte[] text, int startIndex) {
            this.matchPoint = -1;
            int j = 0;
            if (text.length == 0 || startIndex > text.length) {
                return -1;
            }
            int end = text.length;
            for (int i = startIndex; i < end; ++i) {
                while (j > 0 && this.bytePattern[j] != text[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == text[i]) {
                    ++j;
                }
                if (j == this.bytePattern.length) {
                    this.matchPoint = i - this.bytePattern.length + 1;
                    if (text.length - i > this.bytePattern.length) {
                        j = 0;
                        continue;
                    }
                    return this.matchPoint;
                }
                if (startIndex == 0 || i + 1 != end) continue;
                end = startIndex;
                i = -1;
                startIndex = 0;
            }
            return this.matchPoint;
        }

        public int lastIndexOfWithNoLoop(byte[] text, int startIndex) {
            this.matchPoint = -1;
            int j = 0;
            if (text.length == 0 || startIndex > text.length) {
                return -1;
            }
            for (int i = startIndex; i < text.length; ++i) {
                while (j > 0 && this.bytePattern[j] != text[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == text[i]) {
                    ++j;
                }
                if (j != this.bytePattern.length) continue;
                this.matchPoint = i - this.bytePattern.length + 1;
                if (text.length - i > this.bytePattern.length) {
                    j = 0;
                    continue;
                }
                return this.matchPoint;
            }
            return this.matchPoint;
        }

        public void computeFailure4Byte(byte[] patternStr) {
            this.bytePattern = patternStr;
            int j = 0;
            int len = this.bytePattern.length;
            this.failure = new int[len];
            for (int i = 1; i < len; ++i) {
                while (j > 0 && this.bytePattern[j] != this.bytePattern[i]) {
                    j = this.failure[j - 1];
                }
                if (this.bytePattern[j] == this.bytePattern[i]) {
                    // empty if block
                }
                this.failure[i] = ++j;
            }
        }
    }
}

