/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class Http2ServerUpgradeHandler
extends ChannelHandlerAdapter {
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer((ByteBuf)Http2CodecUtil.connectionPrefaceBuf());
    private final EventLoopGroup bizGroup;
    private final HttpServerCodec httpServerCodec;
    private final HttpServerUpgradeHandler httpServerUpgradeHandler;
    private final ChannelHandler http2ServerHandler;

    public Http2ServerUpgradeHandler(EventLoopGroup bizGroup, HttpServerCodec httpServerCodec, HttpServerUpgradeHandler httpServerUpgradeHandler, ChannelHandler http2ServerHandler) {
        this.bizGroup = (EventLoopGroup)ObjectUtil.checkNotNull((Object)bizGroup, (String)"bizGroup");
        this.httpServerCodec = (HttpServerCodec)ObjectUtil.checkNotNull((Object)httpServerCodec, (String)"httpServerCodec");
        this.httpServerUpgradeHandler = (HttpServerUpgradeHandler)ObjectUtil.checkNotNull((Object)httpServerUpgradeHandler, (String)"httpServerUpgradeHandler");
        this.http2ServerHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)http2ServerHandler, (String)"http2ServerHandler");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)new PriorKnowledgeHandler()).addBefore(ctx.name(), "HttpServerCodec", (ChannelHandler)this.httpServerCodec).replace((ChannelHandler)this, "HttpServerUpgradeHandler", (ChannelHandler)this.httpServerUpgradeHandler);
    }

    public static final class PriorKnowledgeUpgradeEvent {
        private static final PriorKnowledgeUpgradeEvent INSTANCE = new PriorKnowledgeUpgradeEvent();

        private PriorKnowledgeUpgradeEvent() {
        }
    }

    private final class PriorKnowledgeHandler
    extends ByteToMessageDecoder {
        private PriorKnowledgeHandler() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            int prefaceLength = CONNECTION_PREFACE.readableBytes();
            int bytesRead = Math.min(in.readableBytes(), prefaceLength);
            if (!ByteBufUtil.equals((ByteBuf)CONNECTION_PREFACE, (int)CONNECTION_PREFACE.readerIndex(), (ByteBuf)in, (int)in.readerIndex(), (int)bytesRead)) {
                ctx.pipeline().remove((ChannelHandler)this);
            } else if (bytesRead == prefaceLength) {
                ctx.pipeline().remove((ChannelHandler)Http2ServerUpgradeHandler.this.httpServerCodec).remove((ChannelHandler)Http2ServerUpgradeHandler.this.httpServerUpgradeHandler);
                ctx.pipeline().addAfter((EventExecutorGroup)Http2ServerUpgradeHandler.this.bizGroup, ctx.name(), null, Http2ServerUpgradeHandler.this.http2ServerHandler);
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireUserEventTriggered((Object)PriorKnowledgeUpgradeEvent.INSTANCE);
            }
        }
    }
}

