/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class ST_Transform<R>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -5769818355081378907L;
    private final Expression<R, GeometryWrapper> geometry;

    ST_Transform(Expression<R, ?>[] parameters, Geometries<?> library) {
        super(SQLMM.ST_Transform, parameters, 1);
        this.geometry = ST_Transform.toGeometryWrapper(library, parameters[0]);
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new ST_Transform<R>(effective, this.getGeometryLibrary());
    }

    @Override
    public Class<? super R> getResourceClass() {
        return ST_Transform.specializedClass(this.geometry.getResourceClass(), super.getResourceClass());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return ST_Transform.getGeometryLibrary(this.geometry);
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return List.of(ST_Transform.unwrap(this.geometry), this.srid);
    }

    @Override
    public Object apply(R input) {
        GeometryWrapper value = this.geometry.apply(input);
        if (value != null) {
            try {
                return this.getGeometryLibrary().getGeometry(value.transform(this.getTargetCRS(input)));
            }
            catch (BackingStoreException e) {
                Throwable cause = e.getCause();
                this.warning((Exception)(cause instanceof Exception ? (Exception)cause : e));
            }
            catch (UnsupportedOperationException | TransformException | FactoryException e) {
                this.warning((Exception)e);
            }
        }
        return null;
    }
}

