/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.profile.provider.handler;

import com.google.perftools.profiles.ProfileProto;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.profile.v3.GoProfileData;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskCommandQuery;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskFinishReport;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskGrpc;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadSnapshot;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.cache.ProfileTaskCache;
import org.apache.skywalking.oap.server.core.command.CommandService;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileLanguageType;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskLogRecord;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLogOperationType;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofParser;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofSegmentParser;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTaskServiceHandler
extends ProfileTaskGrpc.ProfileTaskImplBase
implements GRPCHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileTaskServiceHandler.class);
    private ProfileTaskCache profileTaskCache;
    private final CommandService commandService;

    public ProfileTaskServiceHandler(ModuleManager moduleManager) {
        this.profileTaskCache = (ProfileTaskCache)moduleManager.find("core").provider().getService(ProfileTaskCache.class);
        this.commandService = (CommandService)moduleManager.find("core").provider().getService(CommandService.class);
    }

    public void getProfileTaskCommands(ProfileTaskCommandQuery request, StreamObserver<Commands> responseObserver) {
        String serviceId = IDManager.ServiceID.buildId((String)request.getService(), (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)request.getServiceInstance());
        List profileTaskList = this.profileTaskCache.getProfileTaskList(serviceId);
        if (CollectionUtils.isEmpty((List)profileTaskList)) {
            responseObserver.onNext((Object)Commands.newBuilder().build());
            responseObserver.onCompleted();
            return;
        }
        Commands.Builder commandsBuilder = Commands.newBuilder();
        long lastCommandTime = request.getLastCommandTime();
        for (ProfileTask profileTask : profileTaskList) {
            if (profileTask.getCreateTime() <= lastCommandTime) continue;
            this.recordProfileTaskLog(profileTask, serviceInstanceId, ProfileTaskLogOperationType.NOTIFIED);
            commandsBuilder.addCommands(this.commandService.newProfileTaskCommand(profileTask).serialize().build());
        }
        responseObserver.onNext((Object)commandsBuilder.build());
        responseObserver.onCompleted();
    }

    public StreamObserver<ThreadSnapshot> collectSnapshot(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<ThreadSnapshot>(){

            public void onNext(ThreadSnapshot snapshot) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("receive profile segment snapshot");
                }
                ProfileThreadSnapshotRecord record = new ProfileThreadSnapshotRecord();
                record.setTaskId(snapshot.getTaskId());
                record.setSegmentId(snapshot.getTraceSegmentId());
                record.setDumpTime(snapshot.getTime());
                record.setSequence(snapshot.getSequence());
                record.setStackBinary(snapshot.getStack().toByteArray());
                record.setTimeBucket(TimeBucket.getRecordTimeBucket((long)snapshot.getTime()));
                record.setLanguage(ProfileLanguageType.JAVA);
                RecordStreamProcessor.getInstance().in((Record)record);
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                LOGGER.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }

    public StreamObserver<GoProfileData> goProfileReport(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<GoProfileData>(){
            private ByteArrayOutputStream profileDataBuffer = new ByteArrayOutputStream();
            private String currentTaskId = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(GoProfileData profileData) {
                LOGGER.debug("receive go profile data: taskId='{}', payloadSize={}, isLast={}", new Object[]{profileData.getTaskId(), profileData.getPayload().size(), profileData.getIsLast()});
                if (profileData.getTaskId() == null || profileData.getTaskId().isEmpty()) {
                    LOGGER.error("Go agent sent empty taskId! This indicates a problem with Go agent's profile task management. Please check Go agent's profile task creation and task.TaskID assignment.");
                    return;
                }
                if (this.currentTaskId == null || !this.currentTaskId.equals(profileData.getTaskId())) {
                    this.currentTaskId = profileData.getTaskId();
                    this.profileDataBuffer.reset();
                    LOGGER.debug("Starting new task: {}", (Object)this.currentTaskId);
                }
                try {
                    this.profileDataBuffer.write(profileData.getPayload().toByteArray());
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write Go profile data", (Throwable)e);
                    return;
                }
                if (profileData.getIsLast()) {
                    try {
                        ProfileProto.Profile profile = PprofParser.parseProfile((byte[])this.profileDataBuffer.toByteArray());
                        List segments = PprofSegmentParser.parseSegments((ProfileProto.Profile)profile);
                        if (CollectionUtils.isEmpty((List)segments)) {
                            LOGGER.debug("Parsed Go profile has no segments. taskId={}, hint=check labels segment_id/trace_id", (Object)this.currentTaskId);
                        }
                        for (PprofSegmentParser.SegmentInfo segmentInfo : segments) {
                            ProfileTaskServiceHandler.this.storeGoProfileSegment(segmentInfo, this.currentTaskId, profile);
                        }
                        LOGGER.info("Processed Go profile data: taskId={}, segments={}", (Object)this.currentTaskId, (Object)segments.size());
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse Go profile data for task: " + this.currentTaskId, (Throwable)e);
                    }
                    finally {
                        this.profileDataBuffer.reset();
                        this.currentTaskId = null;
                    }
                }
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                LOGGER.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }

    public void reportTaskFinish(ProfileTaskFinishReport request, StreamObserver<Commands> responseObserver) {
        String serviceId = IDManager.ServiceID.buildId((String)request.getService(), (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)request.getServiceInstance());
        ProfileTask profileTask = this.profileTaskCache.getProfileTaskById(request.getTaskId());
        if (profileTask != null) {
            this.recordProfileTaskLog(profileTask, serviceInstanceId, ProfileTaskLogOperationType.EXECUTION_FINISHED);
        }
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }

    private void recordProfileTaskLog(ProfileTask task, String instanceId, ProfileTaskLogOperationType operationType) {
        ProfileTaskLogRecord logRecord = new ProfileTaskLogRecord();
        logRecord.setTaskId(task.getId());
        logRecord.setInstanceId(instanceId);
        logRecord.setOperationType(operationType.getCode());
        logRecord.setOperationTime(System.currentTimeMillis());
        long timestamp = task.getStartTime() + TimeUnit.MINUTES.toMillis(task.getDuration());
        logRecord.setTimeBucket(TimeBucket.getRecordTimeBucket((long)timestamp));
        logRecord.setTimestamp(timestamp);
        RecordStreamProcessor.getInstance().in((Record)logRecord);
    }

    private void storeGoProfileSegment(PprofSegmentParser.SegmentInfo segmentInfo, String taskId, ProfileProto.Profile originalProfile) {
        try {
            ProfileProto.Profile.Builder filteredProfileBuilder = originalProfile.toBuilder();
            filteredProfileBuilder.clearSample();
            for (ProfileProto.Sample sample : originalProfile.getSampleList()) {
                String sampleSegmentId = PprofSegmentParser.extractSegmentIdFromLabels((List)sample.getLabelList(), (List)originalProfile.getStringTableList());
                if (!segmentInfo.getSegmentId().equals(sampleSegmentId)) continue;
                filteredProfileBuilder.addSample(sample);
            }
            ProfileProto.Profile filteredProfile = filteredProfileBuilder.build();
            byte[] filteredPprofData = filteredProfile.toByteArray();
            ProfileThreadSnapshotRecord record = new ProfileThreadSnapshotRecord();
            record.setTaskId(taskId);
            record.setSegmentId(segmentInfo.getSegmentId());
            long dumpTimeMs = originalProfile.getTimeNanos() > 0L ? originalProfile.getTimeNanos() / 1000000L : System.currentTimeMillis();
            record.setDumpTime(dumpTimeMs);
            record.setSequence(0);
            record.setLanguage(ProfileLanguageType.GO);
            record.setStackBinary(filteredPprofData);
            record.setTimeBucket(TimeBucket.getRecordTimeBucket((long)dumpTimeMs));
            LOGGER.info("About to store Go profile snapshot: taskId={}, segmentId={}, dumpTime={}, timeBucket={}, sequence={}, language={}, filteredDataSize={}, samples={}", new Object[]{record.getTaskId(), record.getSegmentId(), record.getDumpTime(), record.getTimeBucket(), record.getSequence(), record.getLanguage(), filteredPprofData.length, filteredProfile.getSampleCount()});
            RecordStreamProcessor.getInstance().in((Record)record);
            LOGGER.info("Stored Go profile snapshot: taskId={}, segmentId={}, dumpTime={}, sequence={}, language={}", new Object[]{record.getTaskId(), record.getSegmentId(), record.getDumpTime(), record.getSequence(), record.getLanguage()});
        }
        catch (Exception e) {
            LOGGER.error("Failed to store Go profile segment: segmentId={}, taskId={}", new Object[]{segmentInfo.getSegmentId(), taskId, e});
        }
    }
}

