/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm;

import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.annotation.SQLDatabase;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=13, name="Alarm")
@Stream(name="alarm_record", scopeId=13, builder=Builder.class, processor=RecordStreamProcessor.class)
@SQLDatabase.ExtraColumn4AdditionalEntity(additionalTable="alarm_record_tag", parentColumn="time_bucket")
@BanyanDB.TimestampColumn(value="start_time")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class AlarmRecord
extends Record {
    public static final String INDEX_NAME = "alarm_record";
    public static final String ADDITIONAL_TAG_TABLE = "alarm_record_tag";
    public static final String SCOPE = "scope";
    public static final String NAME = "name";
    public static final String ID0 = "id0";
    public static final String ID1 = "id1";
    public static final String START_TIME = "start_time";
    public static final String ALARM_MESSAGE = "alarm_message";
    public static final String RULE_NAME = "rule_name";
    public static final String TAGS = "tags";
    public static final String TAGS_RAW_DATA = "tags_raw_data";
    public static final String SNAPSHOT = "snapshot";
    @Column(name="scope")
    private int scope;
    @Column(name="name", storageOnly=true, length=512)
    private String name;
    @Column(name="id0", storageOnly=true, length=512)
    @BanyanDB.SeriesID(index=0)
    private String id0;
    @Column(name="id1", storageOnly=true)
    private String id1;
    @ElasticSearch.EnableDocValues
    @Column(name="start_time")
    private long startTime;
    @Column(name="alarm_message", length=512)
    @ElasticSearch.MatchQuery
    @BanyanDB.MatchQuery(analyzer=BanyanDB.MatchQuery.AnalyzerType.SIMPLE)
    private String alarmMessage;
    @Column(name="rule_name")
    private String ruleName;
    @Column(name="tags", indexOnly=true)
    @SQLDatabase.AdditionalEntity(additionalTables={"alarm_record_tag"})
    private List<String> tagsInString;
    @Column(name="tags_raw_data", storageOnly=true, length=256)
    private byte[] tagsRawData;
    @Column(name="snapshot", storageOnly=true, length=50000)
    private String snapshot;

    @Override
    public StorageID id() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append(RULE_NAME, this.ruleName).append(ID0, this.id0).append(ID1, this.id1);
    }

    @Generated
    public int getScope() {
        return this.scope;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getId0() {
        return this.id0;
    }

    @Generated
    public String getId1() {
        return this.id1;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    @Generated
    public String getRuleName() {
        return this.ruleName;
    }

    @Generated
    public List<String> getTagsInString() {
        return this.tagsInString;
    }

    @Generated
    public byte[] getTagsRawData() {
        return this.tagsRawData;
    }

    @Generated
    public String getSnapshot() {
        return this.snapshot;
    }

    @Generated
    public void setScope(int scope) {
        this.scope = scope;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setId0(String id0) {
        this.id0 = id0;
    }

    @Generated
    public void setId1(String id1) {
        this.id1 = id1;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    @Generated
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    @Generated
    public void setTagsInString(List<String> tagsInString) {
        this.tagsInString = tagsInString;
    }

    @Generated
    public void setTagsRawData(byte[] tagsRawData) {
        this.tagsRawData = tagsRawData;
    }

    @Generated
    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public static class Builder
    implements StorageBuilder<AlarmRecord> {
        @Override
        public AlarmRecord storage2Entity(Convert2Entity converter) {
            AlarmRecord record = new AlarmRecord();
            record.setScope(((Number)converter.get(AlarmRecord.SCOPE)).intValue());
            record.setName((String)converter.get(AlarmRecord.NAME));
            record.setId0((String)converter.get(AlarmRecord.ID0));
            record.setId1((String)converter.get(AlarmRecord.ID1));
            record.setAlarmMessage((String)converter.get(AlarmRecord.ALARM_MESSAGE));
            record.setStartTime(((Number)converter.get(AlarmRecord.START_TIME)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            record.setRuleName((String)converter.get(AlarmRecord.RULE_NAME));
            record.setTagsRawData(converter.getBytes(AlarmRecord.TAGS_RAW_DATA));
            record.setSnapshot((String)converter.get(AlarmRecord.SNAPSHOT));
            return record;
        }

        @Override
        public void entity2Storage(AlarmRecord storageData, Convert2Storage converter) {
            converter.accept(AlarmRecord.SCOPE, storageData.getScope());
            converter.accept(AlarmRecord.NAME, storageData.getName());
            converter.accept(AlarmRecord.ID0, storageData.getId0());
            converter.accept(AlarmRecord.ID1, storageData.getId1());
            converter.accept(AlarmRecord.ALARM_MESSAGE, storageData.getAlarmMessage());
            converter.accept(AlarmRecord.START_TIME, storageData.getStartTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(AlarmRecord.RULE_NAME, storageData.getRuleName());
            converter.accept(AlarmRecord.TAGS_RAW_DATA, storageData.getTagsRawData());
            converter.accept(AlarmRecord.TAGS, storageData.getTagsInString());
            converter.accept(AlarmRecord.SNAPSHOT, storageData.getSnapshot());
        }
    }
}

