/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.trace;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=66, name="SampledStatus4xxTraceRecord", catalog="PROCESS_RELATION")
@Stream(name="sampled_status_4xx_trace_record", scopeId=66, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="timestamp")
@BanyanDB.Group(streamGroup=BanyanDB.StreamGroup.RECORDS)
public class SampledStatus4xxTraceRecord
extends Record {
    public static final String INDEX_NAME = "sampled_status_4xx_trace_record";
    public static final String SCOPE = "scope";
    public static final String ENTITY_ID = "entity_id";
    public static final String TRACE_ID = "trace_id";
    public static final String URI = "statement";
    public static final String LATENCY = "latency";
    public static final String TIMESTAMP = "timestamp";
    @Column(name="scope")
    private int scope;
    @ElasticSearch.EnableDocValues
    @Column(name="entity_id")
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="trace_id", storageOnly=true)
    private String traceId;
    @Column(name="statement", storageOnly=true)
    private String uri;
    @ElasticSearch.EnableDocValues
    @BanyanDB.EnableSort
    @Column(name="latency", dataType=Column.ValueDataType.SAMPLED_RECORD)
    private long latency;
    @ElasticSearch.EnableDocValues
    @Column(name="timestamp")
    private long timestamp;

    @Override
    public StorageID id() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append(ENTITY_ID, this.entityId).append(TRACE_ID, this.traceId);
    }

    @Generated
    public void setScope(int scope) {
        this.scope = scope;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setLatency(long latency) {
        this.latency = latency;
    }

    @Generated
    public int getScope() {
        return this.scope;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public long getLatency() {
        return this.latency;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    public static class Builder
    implements StorageBuilder<SampledStatus4xxTraceRecord> {
        @Override
        public SampledStatus4xxTraceRecord storage2Entity(Convert2Entity converter) {
            SampledStatus4xxTraceRecord record = new SampledStatus4xxTraceRecord();
            record.setScope(((Number)converter.get(SampledStatus4xxTraceRecord.SCOPE)).intValue());
            record.setEntityId((String)converter.get(SampledStatus4xxTraceRecord.ENTITY_ID));
            record.setTraceId((String)converter.get(SampledStatus4xxTraceRecord.TRACE_ID));
            record.setUri((String)converter.get(SampledStatus4xxTraceRecord.URI));
            record.setLatency(((Number)converter.get(SampledStatus4xxTraceRecord.LATENCY)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            record.setTimestamp(((Number)converter.get(SampledStatus4xxTraceRecord.TIMESTAMP)).longValue());
            return record;
        }

        @Override
        public void entity2Storage(SampledStatus4xxTraceRecord entity, Convert2Storage converter) {
            converter.accept(SampledStatus4xxTraceRecord.SCOPE, entity.getScope());
            converter.accept(SampledStatus4xxTraceRecord.ENTITY_ID, entity.getEntityId());
            converter.accept(SampledStatus4xxTraceRecord.TRACE_ID, entity.getTraceId());
            converter.accept(SampledStatus4xxTraceRecord.URI, entity.getUri());
            converter.accept(SampledStatus4xxTraceRecord.LATENCY, entity.getLatency());
            converter.accept("time_bucket", entity.getTimeBucket());
            converter.accept(SampledStatus4xxTraceRecord.TIMESTAMP, entity.getTimestamp());
        }
    }
}

