/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TraceScopeCondition;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class LogQueryService
implements Service {
    private final ModuleManager moduleManager;
    private ILogQueryDAO logQueryDAO;

    public LogQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private ILogQueryDAO getLogQueryDAO() {
        if (this.logQueryDAO == null) {
            this.logQueryDAO = (ILogQueryDAO)this.moduleManager.find("storage").provider().getService(ILogQueryDAO.class);
        }
        return this.logQueryDAO;
    }

    public boolean supportQueryLogsByKeywords() {
        return this.getLogQueryDAO().supportQueryLogsByKeywords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logs queryLogs(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Pagination paging, Order queryOrder, Duration duration, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                StringBuilder msg = new StringBuilder();
                span = traceContext.createSpan("Query Service: queryLogs");
                msg.append("ServiceId: ").append(serviceId).append(", ");
                msg.append("ServiceInstanceId: ").append(serviceInstanceId).append(", ");
                msg.append("EndpointId: ").append(endpointId).append(", ");
                msg.append("RelatedTrace: ").append(relatedTrace).append(", ");
                msg.append("Pagination: ").append(paging).append(", ");
                msg.append("QueryOrder: ").append((Object)queryOrder).append(", ");
                msg.append("Duration: ").append(duration).append(", ");
                msg.append("Tags: ").append(tags).append(", ");
                msg.append("KeywordsOfContent: ").append(keywordsOfContent).append(", ");
                msg.append("ExcludingKeywordsOfContent: ").append(excludingKeywordsOfContent);
                span.setMsg(msg.toString());
            }
            Logs logs = this.invokeQueryLogs(serviceId, serviceInstanceId, endpointId, relatedTrace, paging, queryOrder, duration, tags, keywordsOfContent, excludingKeywordsOfContent);
            if (traceContext != null) {
                traceContext.stopSpan(span);
            }
            return logs;
        }
        catch (Throwable throwable) {
            if (traceContext != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    private Logs invokeQueryLogs(String serviceId, String serviceInstanceId, String endpointId, TraceScopeCondition relatedTrace, Pagination paging, Order queryOrder, Duration duration, List<Tag> tags, List<String> keywordsOfContent, List<String> excludingKeywordsOfContent) throws IOException {
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
        if (Objects.nonNull(keywordsOfContent)) {
            keywordsOfContent = keywordsOfContent.stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        }
        if (Objects.nonNull(excludingKeywordsOfContent)) {
            excludingKeywordsOfContent = excludingKeywordsOfContent.stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        }
        Logs logs = this.getLogQueryDAO().queryLogsDebuggable(serviceId, serviceInstanceId, endpointId, relatedTrace, queryOrder, page.getFrom(), page.getLimit(), duration, tags, keywordsOfContent, excludingKeywordsOfContent);
        logs.getLogs().forEach(log -> {
            if (StringUtil.isNotEmpty((String)log.getServiceId())) {
                IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(log.getServiceId());
                log.setServiceName(serviceIDDefinition.getName());
            }
            if (StringUtil.isNotEmpty((String)log.getServiceInstanceId())) {
                IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(log.getServiceInstanceId());
                log.setServiceInstanceName(instanceIDDefinition.getName());
            }
        });
        return logs;
    }
}

