/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.alarm.AlarmSnapshotRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.mqe.MQEMetric;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.type.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.type.AlarmSnapshot;
import org.apache.skywalking.oap.server.core.query.type.Alarms;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.storage.DAO;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public interface IAlarmQueryDAO
extends DAO {
    public static final Gson GSON = new Gson();

    public Alarms getAlarm(Integer var1, String var2, int var3, int var4, Duration var5, List<Tag> var6) throws IOException;

    default public void parseDataBinaryBase64(String dataBinaryBase64, List<KeyValue> tags) {
        this.parseDataBinary(Base64.getDecoder().decode(dataBinaryBase64), tags);
    }

    default public void parseDataBinary(byte[] dataBinary, List<KeyValue> tags) {
        List tagList = (List)GSON.fromJson(new String(dataBinary, Charsets.UTF_8), new TypeToken<List<Tag>>(){}.getType());
        tagList.forEach(pair -> tags.add(new KeyValue(pair.getKey(), pair.getValue())));
    }

    default public AlarmMessage buildAlarmMessage(AlarmRecord alarmRecord) {
        AlarmMessage message = new AlarmMessage();
        message.setId(String.valueOf(alarmRecord.getId0()));
        message.setId1(String.valueOf(alarmRecord.getId1()));
        message.setName(alarmRecord.getName());
        message.setMessage(alarmRecord.getAlarmMessage());
        message.setStartTime(alarmRecord.getStartTime());
        message.setScope(Scope.Finder.valueOf(alarmRecord.getScope()));
        message.setScopeId(alarmRecord.getScope());
        AlarmSnapshot alarmSnapshot = message.getSnapshot();
        message.setSnapshot(alarmSnapshot);
        String snapshot = alarmRecord.getSnapshot();
        if (StringUtil.isNotBlank((String)snapshot)) {
            AlarmSnapshotRecord alarmSnapshotRecord = (AlarmSnapshotRecord)GSON.fromJson(snapshot, AlarmSnapshotRecord.class);
            alarmSnapshot.setExpression(alarmSnapshotRecord.getExpression());
            JsonObject jsonObject = alarmSnapshotRecord.getMetrics();
            if (jsonObject != null) {
                for (Map.Entry obj : jsonObject.entrySet()) {
                    String name = (String)obj.getKey();
                    MQEMetric metrics = new MQEMetric();
                    metrics.setName(name);
                    List values = (List)GSON.fromJson(((JsonElement)obj.getValue()).getAsString(), new TypeToken<List<MQEValues>>(){}.getType());
                    metrics.setResults(values);
                    alarmSnapshot.getMetrics().add(metrics);
                }
            }
        }
        return message;
    }
}

