/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.Service;

public interface ITopologyQueryDAO
extends Service {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSideDebuggable(Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadServiceRelationsDetectedAtServerSide");
                span.setMsg("Duration: " + String.valueOf(duration));
            }
            List<Call.CallDetail> list = this.loadServiceRelationsDetectedAtServerSide(duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadServiceRelationDetectedAtClientSideDebuggable(Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadServiceRelationDetectedAtClientSide");
                span.setMsg("Duration: " + String.valueOf(duration));
            }
            List<Call.CallDetail> list = this.loadServiceRelationDetectedAtClientSide(duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSideDebuggable(Duration duration, List<String> serviceIds) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadServiceRelationsDetectedAtServerSide");
                span.setMsg("Duration: " + String.valueOf(duration) + ", ServiceIds: " + String.valueOf(serviceIds));
            }
            List<Call.CallDetail> list = this.loadServiceRelationsDetectedAtServerSide(duration, serviceIds);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadServiceRelationDetectedAtClientSideDebuggable(Duration duration, List<String> serviceIds) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadServiceRelationDetectedAtClientSide");
                span.setMsg("Duration: " + String.valueOf(duration) + ", ServiceIds: " + String.valueOf(serviceIds));
            }
            List<Call.CallDetail> list = this.loadServiceRelationDetectedAtClientSide(duration, serviceIds);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSideDebuggable(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadInstanceRelationDetectedAtServerSide");
                span.setMsg("ClientServiceId: " + clientServiceId + ", ServerServiceId: " + serverServiceId + ", Duration: " + String.valueOf(duration));
            }
            List<Call.CallDetail> list = this.loadInstanceRelationDetectedAtServerSide(clientServiceId, serverServiceId, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSideDebuggable(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadInstanceRelationDetectedAtClientSide");
                span.setMsg("ClientServiceId: " + clientServiceId + ", ServerServiceId: " + serverServiceId + ", Duration: " + String.valueOf(duration));
            }
            List<Call.CallDetail> list = this.loadInstanceRelationDetectedAtClientSide(clientServiceId, serverServiceId, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadEndpointRelationDebuggable(Duration duration, String destEndpointId) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadEndpointRelation");
                span.setMsg("Duration: " + String.valueOf(duration) + ", DestEndpointId: " + destEndpointId);
            }
            List<Call.CallDetail> list = this.loadEndpointRelation(duration, destEndpointId);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadProcessRelationDetectedAtClientSideDebuggable(String serviceInstanceId, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadProcessRelationDetectedAtClientSide");
                span.setMsg("ServiceInstanceId: " + serviceInstanceId + ", Duration: " + String.valueOf(duration));
            }
            List<Call.CallDetail> list = this.loadProcessRelationDetectedAtClientSide(serviceInstanceId, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Call.CallDetail> loadProcessRelationDetectedAtServerSideDebuggable(String serviceInstanceId, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: loadProcessRelationDetectedAtServerSide");
                span.setMsg("ServiceInstanceId: " + serviceInstanceId + ", Duration: " + String.valueOf(duration));
            }
            List<Call.CallDetail> list = this.loadProcessRelationDetectedAtServerSide(serviceInstanceId, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration var1, List<String> var2) throws IOException;

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration var1, List<String> var2) throws IOException;

    public List<Call.CallDetail> loadServiceRelationsDetectedAtServerSide(Duration var1) throws IOException;

    public List<Call.CallDetail> loadServiceRelationDetectedAtClientSide(Duration var1) throws IOException;

    public List<Call.CallDetail> loadInstanceRelationDetectedAtServerSide(String var1, String var2, Duration var3) throws IOException;

    public List<Call.CallDetail> loadInstanceRelationDetectedAtClientSide(String var1, String var2, Duration var3) throws IOException;

    public List<Call.CallDetail> loadEndpointRelation(Duration var1, String var2) throws IOException;

    public List<Call.CallDetail> loadProcessRelationDetectedAtClientSide(String var1, Duration var2) throws IOException;

    public List<Call.CallDetail> loadProcessRelationDetectedAtServerSide(String var1, Duration var2) throws IOException;
}

