/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.AbstractBackoffBuilder;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.FibonacciBackoff;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@UnstableApi
public final class FibonacciBackoffBuilder
extends AbstractBackoffBuilder<FibonacciBackoffBuilder> {
    static final long DEFAULT_INITIAL_DELAY_MILLIS = 200L;
    static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
    private long initialDelayMillis = 200L;
    private long maxDelayMillis = 10000L;

    FibonacciBackoffBuilder() {
    }

    public FibonacciBackoffBuilder initialDelayMillis(long initialDelayMillis) {
        Preconditions.checkArgument(initialDelayMillis >= 0L, "initialDelayMillis: %s (expected: >= 0)", initialDelayMillis);
        this.initialDelayMillis = initialDelayMillis;
        return this;
    }

    public FibonacciBackoffBuilder maxDelayMillis(long maxDelayMillis) {
        Preconditions.checkArgument(maxDelayMillis >= 0L, "maxDelayMillis: %s (expected: >= 0)", maxDelayMillis);
        this.maxDelayMillis = maxDelayMillis;
        return this;
    }

    @Override
    Backoff doBuild() {
        return new FibonacciBackoff(this.initialDelayMillis, this.maxDelayMillis);
    }
}

