/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.HTTPHeader;
import io.fabric8.istio.api.networking.v1alpha3.HTTPHeaderBuilder;
import io.fabric8.istio.api.networking.v1alpha3.HTTPHeaderFluentImpl;
import io.fabric8.istio.api.networking.v1alpha3.HTTPHealthCheckConfig;
import io.fabric8.istio.api.networking.v1alpha3.HTTPHealthCheckConfigFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPHealthCheckConfigFluentImpl<A extends HTTPHealthCheckConfigFluent<A>>
extends BaseFluent<A>
implements HTTPHealthCheckConfigFluent<A> {
    private String host;
    private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList();
    private String path;
    private Integer port;
    private String scheme;

    public HTTPHealthCheckConfigFluentImpl() {
    }

    public HTTPHealthCheckConfigFluentImpl(HTTPHealthCheckConfig instance) {
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withScheme(instance.getScheme());
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public A addToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get((Object)"httpHeaders").add(index, builder);
            this.httpHeaders.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get((Object)"httpHeaders").set(index, builder);
            this.httpHeaders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpHeaders(HTTPHeader ... items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").remove(builder);
            if (this.httpHeaders == null) continue;
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        Iterator<HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        List visitables = this._visitables.get((Object)"httpHeaders");
        while (each.hasNext()) {
            HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPHeader> getHttpHeaders() {
        return this.httpHeaders != null ? HTTPHealthCheckConfigFluentImpl.build(this.httpHeaders) : null;
    }

    @Override
    public List<HTTPHeader> buildHttpHeaders() {
        return this.httpHeaders != null ? HTTPHealthCheckConfigFluentImpl.build(this.httpHeaders) : null;
    }

    @Override
    public HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    @Override
    public HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    @Override
    public HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    @Override
    public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get((Object)"httpHeaders").clear();
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList();
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
            this._visitables.remove((Object)"httpHeaders");
        }
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    @Override
    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNestedImpl();
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNestedImpl(-1, item);
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> setNewHttpHeaderLike(int index, HTTPHeader item) {
        return new HttpHeadersNestedImpl(index, item);
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public HTTPHealthCheckConfigFluent.HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPHealthCheckConfigFluentImpl that = (HTTPHealthCheckConfigFluentImpl)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        return Objects.equals(this.scheme, that.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpHeaders != null) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme);
        }
        sb.append("}");
        return sb.toString();
    }

    class HttpHeadersNestedImpl<N>
    extends HTTPHeaderFluentImpl<HTTPHealthCheckConfigFluent.HttpHeadersNested<N>>
    implements HTTPHealthCheckConfigFluent.HttpHeadersNested<N>,
    Nested<N> {
        HTTPHeaderBuilder builder;
        int index;

        HttpHeadersNestedImpl(int index, HTTPHeader item) {
            this.index = index;
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        HttpHeadersNestedImpl() {
            this.index = -1;
            this.builder = new HTTPHeaderBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPHealthCheckConfigFluentImpl.this.setToHttpHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHttpHeader() {
            return this.and();
        }
    }
}

