/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;

final class LocalVariables<T extends VariableHandle> {
    private final Map<T, VariableAccessor> accessors;
    private final List<Class<?>> frameLocalTypes;

    static <T extends VariableHandle> Builder<T> builderForMethod(MethodDescription method, T[] handles) {
        return new Builder(method, (VariableHandle[])handles);
    }

    private LocalVariables(Map<T, VariableAccessor> accessors, List<Class<?>> frameLocalTypes) {
        this.accessors = new LinkedHashMap<T, VariableAccessor>(accessors);
        this.frameLocalTypes = frameLocalTypes;
    }

    StackManipulation initialize() {
        int numMethodParams = this.accessors.size() - this.frameLocalTypes.size();
        ArrayList ops = new ArrayList();
        this.accessors.values().stream().skip(numMethodParams).forEach(var -> ops.add(((VariableAccessor)var).initialize()));
        return new StackManipulation.Compound(ops);
    }

    StackManipulation load(T var) {
        return this.getAccessor(var).load();
    }

    StackManipulation store(T var) {
        return this.getAccessor(var).store();
    }

    private VariableAccessor getAccessor(T var) {
        VariableAccessor accessor = this.accessors.get(var);
        if (accessor == null) {
            throw new IllegalStateException();
        }
        return accessor;
    }

    int stackSize() {
        return 1 + this.accessors.values().size();
    }

    static class Builder<T extends VariableHandle> {
        private final Map<T, VariableAccessor> accessors = new LinkedHashMap<T, VariableAccessor>();
        private final List<Class<?>> frameLocalTypes = new ArrayList();

        private Builder(MethodDescription method, T[] handles) {
            HashMap<String, T> handlesByName = new HashMap<String, T>();
            for (T handle : handles) {
                String name = handle.name();
                if (handlesByName.containsKey(name)) {
                    throw new IllegalArgumentException("Duplicate VariableHandle with same name, there must only be one handle per variable name: " + name);
                }
                handlesByName.put(name, handle);
            }
            for (ParameterDescription param : method.getParameters()) {
                VariableHandle handle = (VariableHandle)handlesByName.get(param.getName());
                if (handle == null) {
                    throw new IllegalStateException("Could not find VariableHandle with same variableName as parameter. Make sure variable handles match names of method parameters. param name: " + param.getName());
                }
                this.accessors.put(handle, new VariableAccessor(MethodVariableAccess.of((TypeDefinition)param.getType()), param.getOffset(), (TypeDefinition)param.getType()));
            }
        }

        Builder<T> add(Class<?> type, T handle) {
            int nextOffset = 1 + this.accessors.size();
            TypeDescription.ForLoadedType def = new TypeDescription.ForLoadedType(type);
            this.accessors.put(handle, new VariableAccessor(MethodVariableAccess.of((TypeDefinition)def), nextOffset, (TypeDefinition)def));
            this.frameLocalTypes.add(type);
            return this;
        }

        LocalVariables<T> build() {
            return new LocalVariables(this.accessors, this.frameLocalTypes);
        }
    }

    static interface VariableHandle {
        public String name();
    }

    private static final class VariableAccessor {
        private final MethodVariableAccess access;
        private final int offset;
        private final TypeDefinition type;

        private VariableAccessor(MethodVariableAccess access, int offset, TypeDefinition type) {
            this.access = access;
            this.offset = offset;
            this.type = type;
        }

        private StackManipulation initialize() {
            return new StackManipulation.Compound(new StackManipulation[]{DefaultValue.of((TypeDefinition)this.type), this.store()});
        }

        private StackManipulation load() {
            return this.access.loadFrom(this.offset);
        }

        private StackManipulation store() {
            return this.access.storeAt(this.offset);
        }
    }
}

