/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.loadbalancer;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.loadbalancer.SimpleLoadBalancer;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class RoundRobinLoadBalancer<T>
implements SimpleLoadBalancer<T> {
    private final AtomicInteger sequence = new AtomicInteger();
    private final List<T> candidates;

    RoundRobinLoadBalancer(Iterable<? extends T> candidates) {
        this.candidates = ImmutableList.copyOf(candidates);
    }

    @Override
    @Nullable
    public T pick() {
        if (this.candidates.isEmpty()) {
            return null;
        }
        int currentSequence = this.sequence.getAndIncrement();
        return this.candidates.get(Math.abs(currentSequence % this.candidates.size()));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("candidates", this.candidates).toString();
    }
}

