/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.LinkedHashMultimap;
import graphql.com.google.common.collect.Multimap;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLSchemaElementAdapter;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.schema.impl.StronglyConnectedComponentsTopologicallySorted;
import graphql.util.Breadcrumb;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@PublicApi
public class SchemaTransformer {
    public static GraphQLSchema transformSchema(GraphQLSchema schema, GraphQLTypeVisitor visitor) {
        SchemaTransformer schemaTransformer = new SchemaTransformer();
        return schemaTransformer.transform(schema, visitor);
    }

    public static GraphQLSchema transformSchema(GraphQLSchema schema, GraphQLTypeVisitor visitor, Consumer<GraphQLSchema.Builder> postTransformation) {
        SchemaTransformer schemaTransformer = new SchemaTransformer();
        return schemaTransformer.transform(schema, visitor, postTransformation);
    }

    public static <T extends GraphQLSchemaElement> T transformSchema(T schemaElement, GraphQLTypeVisitor visitor) {
        SchemaTransformer schemaTransformer = new SchemaTransformer();
        return schemaTransformer.transform(schemaElement, visitor);
    }

    public GraphQLSchema transform(GraphQLSchema schema, GraphQLTypeVisitor visitor) {
        return (GraphQLSchema)this.transformImpl(schema, null, visitor, null);
    }

    public GraphQLSchema transform(GraphQLSchema schema, GraphQLTypeVisitor visitor, Consumer<GraphQLSchema.Builder> postTransformation) {
        return (GraphQLSchema)this.transformImpl(schema, null, visitor, postTransformation);
    }

    public <T extends GraphQLSchemaElement> T transform(T schemaElement, GraphQLTypeVisitor visitor) {
        return (T)((GraphQLSchemaElement)this.transformImpl(null, schemaElement, visitor, null));
    }

    private Object transformImpl(GraphQLSchema schema, GraphQLSchemaElement schemaElement, GraphQLTypeVisitor visitor, Consumer<GraphQLSchema.Builder> postTransformation) {
        DummyRoot dummyRoot;
        GraphQLCodeRegistry.Builder codeRegistry = null;
        if (schema != null) {
            dummyRoot = new DummyRoot(schema);
            codeRegistry = GraphQLCodeRegistry.newCodeRegistry(schema.getCodeRegistry());
        } else {
            dummyRoot = new DummyRoot(schemaElement);
        }
        LinkedHashMap<String, GraphQLNamedType> changedTypes = new LinkedHashMap<String, GraphQLNamedType>();
        LinkedHashMap<String, GraphQLTypeReference> typeReferences = new LinkedHashMap<String, GraphQLTypeReference>();
        boolean schemaChanged = this.traverseAndTransform(dummyRoot, changedTypes, typeReferences, visitor, codeRegistry, schema);
        if (!changedTypes.isEmpty()) {
            boolean hasTypeRefsForChangedTypes = changedTypes.keySet().stream().anyMatch(typeReferences::containsKey);
            if (hasTypeRefsForChangedTypes) {
                this.replaceTypeReferences(dummyRoot, schema, codeRegistry, changedTypes);
            }
        }
        if (schema != null) {
            GraphQLSchema graphQLSchema = schema;
            if (schemaChanged || codeRegistry.hasChanged()) {
                graphQLSchema = dummyRoot.rebuildSchema(codeRegistry);
                if (postTransformation != null) {
                    graphQLSchema = graphQLSchema.transform(postTransformation);
                }
            }
            return graphQLSchema;
        }
        return dummyRoot.schemaElement;
    }

    private void replaceTypeReferences(DummyRoot dummyRoot, GraphQLSchema schema, GraphQLCodeRegistry.Builder codeRegistry, final Map<String, GraphQLNamedType> changedTypes) {
        GraphQLTypeVisitorStub typeRefVisitor = new GraphQLTypeVisitorStub(){

            @Override
            public TraversalControl visitGraphQLTypeReference(GraphQLTypeReference typeRef, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLNamedType graphQLNamedType = (GraphQLNamedType)changedTypes.get(typeRef.getName());
                if (graphQLNamedType != null) {
                    typeRef = GraphQLTypeReference.typeRef(graphQLNamedType.getName());
                    return this.changeNode(context, typeRef);
                }
                return TraversalControl.CONTINUE;
            }
        };
        this.traverseAndTransform(dummyRoot, new HashMap<String, GraphQLNamedType>(), new HashMap<String, GraphQLTypeReference>(), typeRefVisitor, codeRegistry, schema);
    }

    private boolean traverseAndTransform(final DummyRoot dummyRoot, final Map<String, GraphQLNamedType> changedTypes, final Map<String, GraphQLTypeReference> typeReferences, final GraphQLTypeVisitor visitor, GraphQLCodeRegistry.Builder codeRegistry, GraphQLSchema schema) {
        final LinkedList<NodeZipper<GraphQLSchemaElement>> zippers = new LinkedList<NodeZipper<GraphQLSchemaElement>>();
        final LinkedHashMap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> zipperByNodeAfterTraversing = new LinkedHashMap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>>();
        final LinkedHashMap zipperByOriginalNode = new LinkedHashMap();
        final LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>>();
        final LinkedHashMap<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies = new LinkedHashMap<GraphQLSchemaElement, List<GraphQLSchemaElement>>();
        final LinkedHashMap<String, List<GraphQLSchemaElement>> typeRefReverseDependencies = new LinkedHashMap<String, List<GraphQLSchemaElement>>();
        TraverserVisitor<GraphQLSchemaElement> nodeTraverserVisitor = new TraverserVisitor<GraphQLSchemaElement>(){

            @Override
            public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
                GraphQLSchemaElement currentSchemaElement = context.thisNode();
                if (currentSchemaElement == dummyRoot) {
                    return TraversalControl.CONTINUE;
                }
                if (currentSchemaElement instanceof GraphQLTypeReference) {
                    GraphQLTypeReference typeRef = (GraphQLTypeReference)currentSchemaElement;
                    typeReferences.put(typeRef.getName(), typeRef);
                }
                NodeZipper nodeZipper = new NodeZipper(currentSchemaElement, context.getBreadcrumbs(), GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
                context.setVar(NodeZipper.class, nodeZipper);
                context.setVar(NodeAdapter.class, GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
                int zippersBefore = zippers.size();
                TraversalControl result = currentSchemaElement.accept(context, visitor);
                if (zippersBefore + 1 == zippers.size()) {
                    nodeZipper = (NodeZipper)zippers.get(zippers.size() - 1);
                    if (context.originalThisNode() instanceof GraphQLNamedType && context.isChanged()) {
                        GraphQLNamedType originalNamedType = (GraphQLNamedType)context.originalThisNode();
                        GraphQLNamedType changedNamedType = (GraphQLNamedType)context.thisNode();
                        if (!originalNamedType.getName().equals(changedNamedType.getName())) {
                            changedTypes.put(originalNamedType.getName(), changedNamedType);
                        }
                    }
                }
                zipperByOriginalNode.put(context.originalThisNode(), nodeZipper);
                if (context.isDeleted()) {
                    zipperByNodeAfterTraversing.put(context.originalThisNode(), nodeZipper);
                } else {
                    zipperByNodeAfterTraversing.put(context.thisNode(), nodeZipper);
                }
                breadcrumbsByZipper.put(nodeZipper, new ArrayList());
                ((List)breadcrumbsByZipper.get(nodeZipper)).add(context.getBreadcrumbs());
                if (nodeZipper.getModificationType() != NodeZipper.ModificationType.DELETE) {
                    reverseDependencies.computeIfAbsent(context.thisNode(), ign -> new ArrayList()).add(context.getParentNode());
                    if (context.originalThisNode() instanceof GraphQLTypeReference) {
                        String typeName = ((GraphQLTypeReference)context.originalThisNode()).getName();
                        typeRefReverseDependencies.computeIfAbsent(typeName, ign -> new ArrayList()).add(context.getParentNode());
                    }
                }
                return result;
            }

            @Override
            public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl backRef(TraverserContext<GraphQLSchemaElement> context) {
                NodeZipper zipper = (NodeZipper)zipperByOriginalNode.get(context.thisNode());
                ((List)breadcrumbsByZipper.get(zipper)).add(context.getBreadcrumbs());
                if (zipper.getModificationType() == NodeZipper.ModificationType.DELETE) {
                    return TraversalControl.CONTINUE;
                }
                visitor.visitBackRef(context);
                List reverseDependenciesForCurNode = (List)reverseDependencies.get(zipper.getCurNode());
                Assert.assertNotNull(reverseDependenciesForCurNode);
                reverseDependenciesForCurNode.add(context.getParentNode());
                return TraversalControl.CONTINUE;
            }
        };
        Traverser<GraphQLSchemaElement> traverser = Traverser.depthFirstWithNamedChildren(GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER::getNamedChildren, zippers, null);
        if (codeRegistry != null) {
            traverser.rootVar(GraphQLCodeRegistry.Builder.class, codeRegistry);
        }
        if (schema != null) {
            traverser.rootVar(GraphQLSchema.class, schema);
        }
        traverser.traverse(dummyRoot, nodeTraverserVisitor);
        List<List<GraphQLSchemaElement>> stronglyConnectedTopologicallySorted = StronglyConnectedComponentsTopologicallySorted.getStronglyConnectedComponentsTopologicallySorted(reverseDependencies, typeRefReverseDependencies);
        return this.zipUpToDummyRoot(zippers, stronglyConnectedTopologicallySorted, breadcrumbsByZipper, zipperByNodeAfterTraversing);
    }

    private boolean zipUpToDummyRoot(List<NodeZipper<GraphQLSchemaElement>> zippers, List<List<GraphQLSchemaElement>> stronglyConnectedTopologicallySorted, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper, Map<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> nodeToZipper) {
        if (zippers.size() == 0) {
            return false;
        }
        RelevantZippersAndBreadcrumbs relevantZippers = new RelevantZippersAndBreadcrumbs(zippers, breadcrumbsByZipper);
        block0: for (int i = stronglyConnectedTopologicallySorted.size() - 1; i >= 0; --i) {
            List<GraphQLSchemaElement> scc = stronglyConnectedTopologicallySorted.get(i);
            if (scc.size() > 1) {
                boolean sccChanged = false;
                ArrayList<GraphQLSchemaElement> unchangedSccElements = new ArrayList<GraphQLSchemaElement>();
                for (GraphQLSchemaElement element : scc) {
                    if (relevantZippers.isRelevantZipper(nodeToZipper.get(element))) {
                        sccChanged = true;
                        continue;
                    }
                    Map<NodeZipper<GraphQLSchemaElement>, Breadcrumb<GraphQLSchemaElement>> zipperWithSameParent = this.zipperWithSameParent(element, relevantZippers, false);
                    if (zipperWithSameParent.size() > 0) {
                        sccChanged = true;
                        continue;
                    }
                    unchangedSccElements.add(element);
                }
                if (!sccChanged) continue;
                for (GraphQLSchemaElement element : unchangedSccElements) {
                    NodeZipper<GraphQLSchemaElement> currentZipper = nodeToZipper.get(element);
                    NodeZipper<GraphQLSchemaElement> newZipper = currentZipper.withNewNode(element.copy());
                    nodeToZipper.put(element, newZipper);
                    relevantZippers.updateZipper(currentZipper, newZipper);
                }
            }
            for (int j = scc.size() - 1; j >= 0; --j) {
                GraphQLSchemaElement element = scc.get(j);
                Map<NodeZipper<GraphQLSchemaElement>, Breadcrumb<GraphQLSchemaElement>> zipperWithSameParent = this.zipperWithSameParent(element, relevantZippers, true);
                if (zipperWithSameParent.size() == 0) continue;
                NodeZipper<GraphQLSchemaElement> newZipper = this.moveUp(element, zipperWithSameParent);
                if (element instanceof DummyRoot) continue block0;
                NodeZipper<GraphQLSchemaElement> curZipperForElement = nodeToZipper.get(element);
                Assert.assertNotNull(curZipperForElement, () -> String.format("curZipperForElement is null for parentNode %s", element));
                relevantZippers.updateZipper(curZipperForElement, newZipper);
            }
        }
        return true;
    }

    private Map<NodeZipper<GraphQLSchemaElement>, Breadcrumb<GraphQLSchemaElement>> zipperWithSameParent(GraphQLSchemaElement parent, RelevantZippersAndBreadcrumbs relevantZippers, boolean cleanup) {
        LinkedHashMap<NodeZipper<GraphQLSchemaElement>, Breadcrumb<GraphQLSchemaElement>> result = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, Breadcrumb<GraphQLSchemaElement>>();
        Collection<NodeZipper<GraphQLSchemaElement>> zippersWithParent = relevantZippers.zippersWithParent(parent);
        block0: for (NodeZipper<GraphQLSchemaElement> zipper : zippersWithParent) {
            List<List<Breadcrumb<GraphQLSchemaElement>>> listOfBreadcrumbsList = Assert.assertNotNull(relevantZippers.getBreadcrumbs(zipper));
            for (int i = 0; i < listOfBreadcrumbsList.size(); ++i) {
                List<Breadcrumb<GraphQLSchemaElement>> path = listOfBreadcrumbsList.get(i);
                if (path.get(0).getNode() != parent) continue;
                result.put(zipper, path.get(0));
                if (!cleanup) continue block0;
                listOfBreadcrumbsList.remove(i);
                if (listOfBreadcrumbsList.size() != 0) continue block0;
                relevantZippers.removeRelevantZipper(zipper);
                continue block0;
            }
        }
        return result;
    }

    private NodeZipper<GraphQLSchemaElement> moveUp(GraphQLSchemaElement parent, Map<NodeZipper<GraphQLSchemaElement>, Breadcrumb<GraphQLSchemaElement>> sameParentsZipper) {
        Set<NodeZipper<GraphQLSchemaElement>> sameParent = sameParentsZipper.keySet();
        Assert.assertNotEmpty(sameParent, () -> "expected at least one zipper");
        HashMap<String, List<GraphQLSchemaElement>> childrenMap = new HashMap<String, List<GraphQLSchemaElement>>(GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER.getNamedChildren(parent));
        HashMap<String, Integer> indexCorrection = new HashMap<String, Integer>();
        ArrayList<ZipperWithOneParent> zipperWithOneParents = new ArrayList<ZipperWithOneParent>();
        for (NodeZipper<GraphQLSchemaElement> zipper : sameParent) {
            Breadcrumb<GraphQLSchemaElement> breadcrumb = sameParentsZipper.get(zipper);
            zipperWithOneParents.add(new ZipperWithOneParent(zipper, breadcrumb));
        }
        zipperWithOneParents.sort((zipperWithOneParent1, zipperWithOneParent2) -> {
            NodeZipper.ModificationType modificationType2;
            int index2;
            NodeZipper<GraphQLSchemaElement> zipper1 = zipperWithOneParent1.zipper;
            NodeZipper<GraphQLSchemaElement> zipper2 = zipperWithOneParent2.zipper;
            Breadcrumb<GraphQLSchemaElement> breadcrumb1 = zipperWithOneParent1.parent;
            Breadcrumb<GraphQLSchemaElement> breadcrumb2 = zipperWithOneParent2.parent;
            int index1 = breadcrumb1.getLocation().getIndex();
            if (index1 != (index2 = breadcrumb2.getLocation().getIndex())) {
                return Integer.compare(index1, index2);
            }
            NodeZipper.ModificationType modificationType1 = zipper1.getModificationType();
            if (modificationType1 == (modificationType2 = zipper2.getModificationType())) {
                return 0;
            }
            if (modificationType1 == NodeZipper.ModificationType.REPLACE) {
                return -1;
            }
            return modificationType1 == NodeZipper.ModificationType.INSERT_BEFORE ? -1 : 1;
        });
        for (ZipperWithOneParent zipperWithOneParent : zipperWithOneParents) {
            NodeZipper<GraphQLSchemaElement> zipper = zipperWithOneParent.zipper;
            Breadcrumb<GraphQLSchemaElement> breadcrumb = zipperWithOneParent.parent;
            NodeLocation location = breadcrumb.getLocation();
            Integer ixDiff = indexCorrection.getOrDefault(location.getName(), 0);
            int ix = location.getIndex() + ixDiff;
            String name = location.getName();
            ArrayList<GraphQLSchemaElement> childList = new ArrayList<GraphQLSchemaElement>((Collection)childrenMap.get(name));
            switch (zipper.getModificationType()) {
                case REPLACE: {
                    childList.set(ix, zipper.getCurNode());
                    break;
                }
                case DELETE: {
                    childList.remove(ix);
                    indexCorrection.put(name, ixDiff - 1);
                    break;
                }
                case INSERT_BEFORE: {
                    childList.add(ix, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                    break;
                }
                case INSERT_AFTER: {
                    childList.add(ix + 1, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                }
            }
            childrenMap.put(name, childList);
        }
        GraphQLSchemaElement newNode = GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER.withNewChildren(parent, (Map<String, List<GraphQLSchemaElement>>)childrenMap);
        List<Breadcrumb<GraphQLSchemaElement>> oldBreadcrumbs = sameParent.iterator().next().getBreadcrumbs();
        List<Object> newBreadcrumbs = oldBreadcrumbs.size() > 1 ? oldBreadcrumbs.subList(1, oldBreadcrumbs.size()) : ImmutableKit.emptyList();
        return new NodeZipper<GraphQLSchemaElement>(newNode, newBreadcrumbs, GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
    }

    private static class DummyRoot
    implements GraphQLSchemaElement {
        static final String QUERY = "query";
        static final String MUTATION = "mutation";
        static final String SUBSCRIPTION = "subscription";
        static final String ADD_TYPES = "addTypes";
        static final String DIRECTIVES = "directives";
        static final String SCHEMA_DIRECTIVES = "schemaDirectives";
        static final String SCHEMA_APPLIED_DIRECTIVES = "schemaAppliedDirectives";
        static final String INTROSPECTION = "introspection";
        static final String SCHEMA_ELEMENT = "schemaElement";
        GraphQLSchema schema;
        GraphQLObjectType query;
        GraphQLObjectType mutation;
        GraphQLObjectType subscription;
        GraphQLObjectType introspectionSchemaType;
        Set<GraphQLType> additionalTypes;
        Set<GraphQLDirective> directives;
        Set<GraphQLDirective> schemaDirectives;
        Set<GraphQLAppliedDirective> schemaAppliedDirectives;
        GraphQLSchemaElement schemaElement;

        DummyRoot(GraphQLSchema schema) {
            this.schema = schema;
            this.query = schema.getQueryType();
            this.mutation = schema.isSupportingMutations() ? schema.getMutationType() : null;
            this.subscription = schema.isSupportingSubscriptions() ? schema.getSubscriptionType() : null;
            this.additionalTypes = schema.getAdditionalTypes();
            this.schemaDirectives = new LinkedHashSet<GraphQLDirective>(schema.getSchemaDirectives());
            this.schemaAppliedDirectives = new LinkedHashSet<GraphQLAppliedDirective>(schema.getSchemaAppliedDirectives());
            this.directives = new LinkedHashSet<GraphQLDirective>(schema.getDirectives());
            this.introspectionSchemaType = schema.getIntrospectionSchemaType();
        }

        DummyRoot(GraphQLSchemaElement schemaElement) {
            this.schemaElement = schemaElement;
        }

        @Override
        public GraphQLSchemaElement copy() {
            return (GraphQLSchemaElement)Assert.assertShouldNeverHappen();
        }

        @Override
        public List<GraphQLSchemaElement> getChildren() {
            return (List)Assert.assertShouldNeverHappen();
        }

        @Override
        public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
            SchemaElementChildrenContainer.Builder builder = SchemaElementChildrenContainer.newSchemaElementChildrenContainer();
            if (this.schemaElement != null) {
                builder.child(SCHEMA_ELEMENT, this.schemaElement);
            } else {
                builder.child(QUERY, this.query);
                if (this.schema.isSupportingMutations()) {
                    builder.child(MUTATION, this.mutation);
                }
                if (this.schema.isSupportingSubscriptions()) {
                    builder.child(SUBSCRIPTION, this.subscription);
                }
                builder.children(ADD_TYPES, this.additionalTypes);
                builder.children(DIRECTIVES, this.directives);
                builder.children(SCHEMA_DIRECTIVES, this.schemaDirectives);
                builder.children(SCHEMA_APPLIED_DIRECTIVES, this.schemaAppliedDirectives);
                builder.child(INTROSPECTION, this.introspectionSchemaType);
            }
            return builder.build();
        }

        @Override
        public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
            if (this.schemaElement != null) {
                this.schemaElement = newChildren.getChildOrNull(SCHEMA_ELEMENT);
                return this;
            }
            this.query = (GraphQLObjectType)newChildren.getChildOrNull(QUERY);
            this.mutation = (GraphQLObjectType)newChildren.getChildOrNull(MUTATION);
            this.subscription = (GraphQLObjectType)newChildren.getChildOrNull(SUBSCRIPTION);
            this.introspectionSchemaType = (GraphQLObjectType)newChildren.getChildOrNull(INTROSPECTION);
            this.additionalTypes = new LinkedHashSet(newChildren.getChildren(ADD_TYPES));
            this.directives = new LinkedHashSet(newChildren.getChildren(DIRECTIVES));
            this.schemaDirectives = new LinkedHashSet(newChildren.getChildren(SCHEMA_DIRECTIVES));
            this.schemaAppliedDirectives = new LinkedHashSet(newChildren.getChildren(SCHEMA_APPLIED_DIRECTIVES));
            return this;
        }

        @Override
        public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
            return (TraversalControl)((Object)Assert.assertShouldNeverHappen());
        }

        public GraphQLSchema rebuildSchema(GraphQLCodeRegistry.Builder codeRegistry) {
            return GraphQLSchema.newSchema().query(this.query).mutation(this.mutation).subscription(this.subscription).additionalTypes(this.additionalTypes).additionalDirectives(this.directives).introspectionSchemaType(this.introspectionSchemaType).withSchemaDirectives(this.schemaDirectives).withSchemaAppliedDirectives(this.schemaAppliedDirectives).codeRegistry(codeRegistry.build()).description(this.schema.getDescription()).build();
        }
    }

    private static class ZipperWithOneParent {
        public NodeZipper<GraphQLSchemaElement> zipper;
        public Breadcrumb<GraphQLSchemaElement> parent;

        public ZipperWithOneParent(NodeZipper<GraphQLSchemaElement> zipper, Breadcrumb<GraphQLSchemaElement> parent) {
            this.zipper = zipper;
            this.parent = parent;
        }
    }

    private static class RelevantZippersAndBreadcrumbs {
        final Multimap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> zipperByParent = LinkedHashMultimap.create();
        final Set<NodeZipper<GraphQLSchemaElement>> relevantZippers;
        final Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper;

        public RelevantZippersAndBreadcrumbs(List<NodeZipper<GraphQLSchemaElement>> relevantZippers, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper) {
            this.relevantZippers = new LinkedHashSet<NodeZipper<GraphQLSchemaElement>>(relevantZippers);
            this.breadcrumbsByZipper = breadcrumbsByZipper;
            for (NodeZipper<GraphQLSchemaElement> zipper : relevantZippers) {
                for (List<Breadcrumb<GraphQLSchemaElement>> breadcrumbs : breadcrumbsByZipper.get(zipper)) {
                    this.zipperByParent.put(breadcrumbs.get(0).getNode(), zipper);
                }
            }
        }

        public boolean isRelevantZipper(NodeZipper<GraphQLSchemaElement> zipper) {
            return this.relevantZippers.contains(zipper);
        }

        public Collection<NodeZipper<GraphQLSchemaElement>> zippersWithParent(GraphQLSchemaElement parent) {
            return this.zipperByParent.get(parent);
        }

        public void removeRelevantZipper(NodeZipper<GraphQLSchemaElement> zipper) {
            this.relevantZippers.remove(zipper);
        }

        public List<List<Breadcrumb<GraphQLSchemaElement>>> getBreadcrumbs(NodeZipper<GraphQLSchemaElement> zipper) {
            return this.breadcrumbsByZipper.get(zipper);
        }

        public void updateZipper(NodeZipper<GraphQLSchemaElement> currentZipper, NodeZipper<GraphQLSchemaElement> newZipper) {
            this.relevantZippers.remove(currentZipper);
            this.relevantZippers.add(newZipper);
            List<List<Breadcrumb<GraphQLSchemaElement>>> currentBreadcrumbs = this.breadcrumbsByZipper.get(currentZipper);
            Assert.assertNotNull(currentBreadcrumbs, () -> String.format("No breadcrumbs found for zipper %s", currentZipper));
            for (List<Breadcrumb<GraphQLSchemaElement>> breadcrumbs : currentBreadcrumbs) {
                GraphQLSchemaElement parent = breadcrumbs.get(0).getNode();
                this.zipperByParent.remove(parent, currentZipper);
                this.zipperByParent.put(parent, newZipper);
            }
            this.breadcrumbsByZipper.remove(currentZipper);
            this.breadcrumbsByZipper.put(newZipper, currentBreadcrumbs);
        }
    }
}

