/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.pprof.parser;

import com.google.perftools.profiles.ProfileProto;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTree;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTreeBuilder;

public class PprofParser {
    public static FrameTree dumpTree(ByteBuffer buf) throws IOException {
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        GZIPInputStream inputStream = new GZIPInputStream(stream);
        ProfileProto.Profile profile = ProfileProto.Profile.parseFrom(inputStream);
        FrameTree tree = new FrameTreeBuilder(profile).build();
        return tree;
    }

    public static FrameTree dumpTree(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IOException("Pprof file not found: " + filePath);
        }
        FileInputStream fileStream = new FileInputStream(file);
        GZIPInputStream stream = new GZIPInputStream(fileStream);
        ProfileProto.Profile profile = ProfileProto.Profile.parseFrom(stream);
        FrameTree tree = new FrameTreeBuilder(profile).build();
        return tree;
    }

    public static String resolveSignature(long locationId, ProfileProto.Profile profile) {
        if (locationId == 0L) {
            return "root";
        }
        ProfileProto.Location location = profile.getLocation((int)locationId - 1);
        return location.getLineList().stream().map(line -> {
            ProfileProto.Function function = profile.getFunction((int)line.getFunctionId() - 1);
            String functionName = profile.getStringTable((int)function.getName());
            return functionName + ":" + line.getLine();
        }).collect(Collectors.joining(";"));
    }

    public static ProfileProto.Profile parseProfile(byte[] payload) throws IOException {
        if (payload == null) {
            throw new IOException("pprof payload is null");
        }
        InputStream input = new ByteArrayInputStream(payload);
        if (payload.length >= 2 && payload[0] == 31 && payload[1] == -117) {
            input = new GZIPInputStream(input);
        }
        return ProfileProto.Profile.parseFrom(input);
    }
}

