/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.net.bytebuddy.agent.builder;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.NamedElement;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.annotation.AnnotationList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.field.FieldDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.field.FieldList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.PackageDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.RecordComponentDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.RecordComponentList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.type.TypeList;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.dynamic.TargetType;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bytecode.StackSize;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.pool.TypePool;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.JavaModule;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.nullability.MaybeNull;

public class SWDescriptionStrategy
implements AgentBuilder.DescriptionStrategy {
    private static final Map<Class<?>, TypeDescription> TYPE_CACHE = new HashMap();
    private AgentBuilder.DescriptionStrategy delegate = AgentBuilder.DescriptionStrategy.Default.HYBRID;
    private String nameTrait;

    public SWDescriptionStrategy(String nameTrait) {
        this.nameTrait = nameTrait;
    }

    @Override
    public boolean isLoadedFirst() {
        return true;
    }

    @Override
    public TypeDescription apply(String name, @MaybeNull Class<?> type, TypePool typePool, AgentBuilder.CircularityLock circularityLock, @MaybeNull ClassLoader classLoader, @MaybeNull JavaModule module) {
        TypeDescription typeDescription;
        if (type != null && (typeDescription = TYPE_CACHE.get(type)) != null) {
            return typeDescription;
        }
        return new SWTypeDescriptionWrapper(this.delegate.apply(name, type, typePool, circularityLock, classLoader, module), this.nameTrait, classLoader, name);
    }

    static {
        TYPE_CACHE.put(TargetType.class, new TypeDescription.ForLoadedType(TargetType.class));
        TYPE_CACHE.put(Class.class, new TypeDescription.ForLoadedType(Class.class));
        TYPE_CACHE.put(Throwable.class, new TypeDescription.ForLoadedType(Throwable.class));
        TYPE_CACHE.put(Annotation.class, new TypeDescription.ForLoadedType(Annotation.class));
        TYPE_CACHE.put(Object.class, new TypeDescription.ForLoadedType(Object.class));
        TYPE_CACHE.put(String.class, new TypeDescription.ForLoadedType(String.class));
        TYPE_CACHE.put(Boolean.class, new TypeDescription.ForLoadedType(Boolean.class));
        TYPE_CACHE.put(Byte.class, new TypeDescription.ForLoadedType(Byte.class));
        TYPE_CACHE.put(Short.class, new TypeDescription.ForLoadedType(Short.class));
        TYPE_CACHE.put(Character.class, new TypeDescription.ForLoadedType(Character.class));
        TYPE_CACHE.put(Integer.class, new TypeDescription.ForLoadedType(Integer.class));
        TYPE_CACHE.put(Long.class, new TypeDescription.ForLoadedType(Long.class));
        TYPE_CACHE.put(Float.class, new TypeDescription.ForLoadedType(Float.class));
        TYPE_CACHE.put(Double.class, new TypeDescription.ForLoadedType(Double.class));
        TYPE_CACHE.put(Void.TYPE, new TypeDescription.ForLoadedType(Void.TYPE));
        TYPE_CACHE.put(Boolean.TYPE, new TypeDescription.ForLoadedType(Boolean.TYPE));
        TYPE_CACHE.put(Byte.TYPE, new TypeDescription.ForLoadedType(Byte.TYPE));
        TYPE_CACHE.put(Short.TYPE, new TypeDescription.ForLoadedType(Short.TYPE));
        TYPE_CACHE.put(Character.TYPE, new TypeDescription.ForLoadedType(Character.TYPE));
        TYPE_CACHE.put(Integer.TYPE, new TypeDescription.ForLoadedType(Integer.TYPE));
        TYPE_CACHE.put(Long.TYPE, new TypeDescription.ForLoadedType(Long.TYPE));
        TYPE_CACHE.put(Float.TYPE, new TypeDescription.ForLoadedType(Float.TYPE));
        TYPE_CACHE.put(Double.TYPE, new TypeDescription.ForLoadedType(Double.TYPE));
    }

    static class SWTypeDescriptionWrapper
    extends TypeDescription.AbstractBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Map<ClassLoader, Map<String, TypeCache>> CLASS_LOADER_TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap());
        private static final Map<String, TypeCache> BOOTSTRAP_TYPE_CACHE = new ConcurrentHashMap<String, TypeCache>();
        private static final List<String> IGNORED_INTERFACES = Arrays.asList(EnhancedInstance.class.getName());
        private MethodList<MethodDescription.InDefinedShape> methods;
        private FieldList<FieldDescription.InDefinedShape> fields;
        private final String nameTrait;
        private ClassLoader classLoader;
        private String typeName;
        private TypeList.Generic interfaces;
        private TypeDescription delegate;

        public SWTypeDescriptionWrapper(TypeDescription delegate, String nameTrait, ClassLoader classLoader, String typeName) {
            this.delegate = delegate;
            this.nameTrait = nameTrait;
            this.classLoader = classLoader;
            this.typeName = typeName;
        }

        private TypeCache getTypeCache() {
            if (this.classLoader == null) {
                return BOOTSTRAP_TYPE_CACHE.computeIfAbsent(this.typeName, k -> new TypeCache(this.typeName));
            }
            Map typeCacheMap = CLASS_LOADER_TYPE_CACHE.computeIfAbsent(this.classLoader, k -> new ConcurrentHashMap());
            return typeCacheMap.computeIfAbsent(this.typeName, k -> new TypeCache(this.typeName));
        }

        @Override
        public TypeList.Generic getInterfaces() {
            if (this.interfaces == null) {
                TypeList.Generic allInterfaces = this.delegate.getInterfaces();
                if (allInterfaces.stream().anyMatch(s -> IGNORED_INTERFACES.contains(s.getTypeName()))) {
                    List list = allInterfaces.stream().filter(s -> !IGNORED_INTERFACES.contains(s.getTypeName())).collect(Collectors.toList());
                    this.interfaces = new TypeList.Generic.Explicit(list);
                } else {
                    this.interfaces = allInterfaces;
                }
            }
            return this.interfaces;
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            if (this.fields == null) {
                FieldList<FieldDescription.InDefinedShape> declaredFields = this.delegate.getDeclaredFields();
                TypeCache typeCache = this.getTypeCache();
                if (typeCache.fieldNames == null) {
                    typeCache.fieldNames = declaredFields.stream().map(NamedElement.WithRuntimeName::getName).collect(Collectors.toSet());
                    this.fields = declaredFields;
                } else {
                    this.fields = new FieldList.Explicit(declaredFields.stream().filter(f -> typeCache.fieldNames.contains(f.getName())).collect(Collectors.toList()));
                }
            }
            return this.fields;
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            if (this.methods == null) {
                MethodList<MethodDescription.InDefinedShape> declaredMethods = this.delegate.getDeclaredMethods();
                TypeCache typeCache = this.getTypeCache();
                if (typeCache.methodCodes == null) {
                    typeCache.methodCodes = declaredMethods.stream().map(m -> m.toString().hashCode()).collect(Collectors.toSet());
                    this.methods = declaredMethods;
                } else {
                    this.methods = new MethodList.Explicit(declaredMethods.stream().filter(m -> typeCache.methodCodes.contains(m.toString().hashCode())).collect(Collectors.toList()));
                }
            }
            return this.methods;
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            if (IGNORED_INTERFACES.contains(type.getName())) {
                return false;
            }
            return this.delegate.isAssignableTo(type);
        }

        @Override
        public boolean isAccessibleTo(TypeDescription typeDescription) {
            if (IGNORED_INTERFACES.contains(typeDescription.getName())) {
                return false;
            }
            return this.delegate.isAccessibleTo(typeDescription);
        }

        @Override
        public RecordComponentList<RecordComponentDescription.InDefinedShape> getRecordComponents() {
            return this.delegate.getRecordComponents();
        }

        @Override
        public TypeDescription getComponentType() {
            return this.delegate.getComponentType();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.delegate.getDeclaringType();
        }

        @Override
        public TypeList getDeclaredTypes() {
            return this.delegate.getDeclaredTypes();
        }

        @Override
        public MethodDescription.InDefinedShape getEnclosingMethod() {
            return this.delegate.getEnclosingMethod();
        }

        @Override
        public TypeDescription getEnclosingType() {
            return this.delegate.getEnclosingType();
        }

        @Override
        public String getSimpleName() {
            return this.delegate.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.delegate.getCanonicalName();
        }

        @Override
        public boolean isAnonymousType() {
            return this.delegate.isAnonymousType();
        }

        @Override
        public boolean isLocalType() {
            return this.delegate.isLocalType();
        }

        @Override
        public PackageDescription getPackage() {
            return this.delegate.getPackage();
        }

        @Override
        public TypeDescription getNestHost() {
            return this.delegate.getNestHost();
        }

        @Override
        public TypeList getNestMembers() {
            return this.delegate.getNestMembers();
        }

        @Override
        public TypeList getPermittedSubtypes() {
            return this.delegate.getPermittedSubtypes();
        }

        @Override
        public String getDescriptor() {
            return this.delegate.getDescriptor();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return this.delegate.getTypeVariables();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.delegate.getDeclaredAnnotations();
        }

        @Override
        public TypeDescription.Generic getSuperClass() {
            return this.delegate.getSuperClass();
        }

        @Override
        public StackSize getStackSize() {
            return this.delegate.getStackSize();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isRecord() {
            return this.delegate.isRecord();
        }

        @Override
        public boolean isPrimitive() {
            return this.delegate.isPrimitive();
        }

        @Override
        public int getModifiers() {
            return this.delegate.getModifiers();
        }
    }

    static class TypeCache {
        private String typeName;
        private Set<Integer> methodCodes;
        private Set<String> fieldNames;

        public TypeCache(String typeName) {
            this.typeName = typeName;
        }
    }
}

