/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import org.apache.sling.auth.oauth_client.ClientConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class, factory=true)
public class OAuthConnectionImpl
implements ClientConnection {
    private final Config cfg;

    @Activate
    public OAuthConnectionImpl(@NotNull Config cfg) {
        this.cfg = cfg;
    }

    @Override
    @NotNull
    public String name() {
        return this.cfg.name();
    }

    @NotNull
    public String authorizationEndpoint() {
        return this.cfg.authorizationEndpoint();
    }

    @NotNull
    public String tokenEndpoint() {
        return this.cfg.tokenEndpoint();
    }

    @NotNull
    public String clientId() {
        return this.cfg.clientId();
    }

    @Nullable
    public String clientSecret() {
        return this.cfg.clientSecret();
    }

    @NotNull
    public String[] scopes() {
        return this.cfg.scopes();
    }

    @NotNull
    public String[] additionalAuthorizationParameters() {
        return this.cfg.additionalAuthorizationParameters();
    }

    @ObjectClassDefinition(name="OAuth connection details")
    public static @interface Config {
        public String name();

        public String authorizationEndpoint();

        public String tokenEndpoint();

        public String clientId();

        @AttributeDefinition(type=AttributeType.PASSWORD)
        public String clientSecret();

        public String[] scopes();

        public String[] additionalAuthorizationParameters();

        public String webconsole_configurationFactory_nameHint() default "Name: {name}, auth endpoint: {authorizationEndpoint}, clientId: {clientId}";
    }
}

