/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.stats;

import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.query.stats.QueryRecorder;

public class QueryStatsData {
    private final String query;
    private final String language;
    private final long createdMillis = System.currentTimeMillis();
    private boolean internal;
    private String lastThreadName;
    private long lastExecutedMillis;
    private long executeCount;
    private long totalRowsRead;
    private long maxRowsRead;
    private long totalRowsScanned;
    private long maxRowsScanned;
    private long planNanos;
    private long readNanos;
    private long maxTimeNanos;
    private boolean captureStackTraces;

    public QueryStatsData(String query, String language) {
        this.query = query;
        this.language = language;
    }

    public String getKey() {
        return this.query + "/" + this.language;
    }

    public long getMaxTimeNanos() {
        return this.maxTimeNanos;
    }

    public long getTotalTimeNanos() {
        return this.planNanos + this.readNanos;
    }

    public long getMaxRowsRead() {
        return this.maxRowsRead;
    }

    public long getMaxRowsScanned() {
        return this.maxRowsScanned;
    }

    public void setCaptureStackTraces(boolean captureStackTraces) {
        this.captureStackTraces = captureStackTraces;
    }

    public long getCreatedMillis() {
        return this.createdMillis;
    }

    public long getExecuteCount() {
        return this.executeCount;
    }

    public long getTotalRowsRead() {
        return this.totalRowsRead;
    }

    public long getTotalRowsScanned() {
        return this.totalRowsScanned;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public String getLastThreadName() {
        return this.lastThreadName;
    }

    public long getLastExecutedMillis() {
        return this.lastExecutedMillis;
    }

    public String toString() {
        return new JsopBuilder().object().key("createdMillis").value(QueryStatsData.getTimeString(this.createdMillis)).key("lastExecutedMillis").value(QueryStatsData.getTimeString(this.lastExecutedMillis)).key("executeCount").value(this.executeCount).key("totalRowsRead").value(this.totalRowsRead).key("maxRowsRead").value(this.maxRowsRead).key("totalRowsScanned").value(this.totalRowsScanned).key("maxRowsScanned").value(this.maxRowsScanned).key("planNanos").value(this.planNanos).key("readNanos").value(this.readNanos).key("maxTimeNanos").value(this.maxTimeNanos).key("internal").value(this.internal).key("query").value(this.query).key("language").value(this.language).key("lastThreadName").value(this.lastThreadName).endObject().toString();
    }

    public static final String getTimeString(long timeMillis) {
        return String.format("%tF %tT", timeMillis, timeMillis);
    }

    public class QueryExecutionStats {
        long time;

        public void execute(long nanos) {
            QueryRecorder.record(QueryStatsData.this.query, QueryStatsData.this.internal);
            ++QueryStatsData.this.executeCount;
            QueryStatsData.this.lastExecutedMillis = System.currentTimeMillis();
            this.time += nanos;
            QueryStatsData.this.planNanos += nanos;
            QueryStatsData.this.maxTimeNanos = Math.max(QueryStatsData.this.maxTimeNanos, this.time);
        }

        public void setInternal(boolean b) {
            QueryStatsData.this.internal = b;
        }

        public void setThreadName(String name) {
            if (QueryStatsData.this.captureStackTraces) {
                StringBuilder buff = new StringBuilder();
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    buff.append("\n\tat " + String.valueOf(e));
                }
                name = (String)name + buff.toString();
            }
            QueryStatsData.this.lastThreadName = name;
        }

        public void read(long count, long max, long nanos) {
            QueryStatsData.this.totalRowsRead += count;
            QueryStatsData.this.maxRowsRead = Math.max(QueryStatsData.this.maxRowsRead, max);
            this.time += nanos;
            QueryStatsData.this.readNanos += nanos;
            QueryStatsData.this.maxTimeNanos = Math.max(QueryStatsData.this.maxTimeNanos, this.time);
        }

        public void scan(long count, long max) {
            QueryStatsData.this.totalRowsScanned += count;
            QueryStatsData.this.maxRowsScanned = Math.max(QueryStatsData.this.maxRowsScanned, max);
        }
    }
}

