/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.maven.mojos;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.maven.ProjectHelper;
import org.apache.sling.feature.maven.mojos.AbstractFeatureMojo;
import org.apache.sling.feature.maven.mojos.FeatureSelectionConfig;
import org.codehaus.plexus.util.AbstractScanner;

public abstract class AbstractIncludingFeatureMojo
extends AbstractFeatureMojo {
    protected Map<String, Feature> getSelectedFeatures(FeatureSelectionConfig config) throws MojoExecutionException {
        LinkedHashMap<String, Feature> result = new LinkedHashMap<String, Feature>();
        if (config == null) {
            return result;
        }
        boolean hasFileInclude = false;
        for (FeatureSelectionConfig.Selection selection : config.getSelections()) {
            switch (selection.type) {
                case FILES_INCLUDE: {
                    hasFileInclude = true;
                    this.selectFeatureFiles(selection.instruction, config.getFilesExcludes(), result);
                    break;
                }
                case CLASSIFIER: {
                    this.selectFeatureClassifier(selection.instruction, result);
                    break;
                }
                case ARTIFACT: {
                    this.selectFeatureArtifact(selection.instruction, result);
                    break;
                }
                case REFS_INCLUDE: {
                    this.selectRefsFiles(selection.instruction, config.getFilesExcludes(), result);
                    break;
                }
            }
        }
        if (!hasFileInclude && !config.getFilesExcludes().isEmpty()) {
            throw new MojoExecutionException("filesExclude configured without filesInclude in " + String.valueOf(config));
        }
        return result;
    }

    protected Map<String, Feature> selectAllFeatureFiles() throws MojoExecutionException {
        FeatureSelectionConfig config = new FeatureSelectionConfig();
        config.setFilesInclude("**/*.*");
        return this.getSelectedFeatures(config);
    }

    protected Map<String, Feature> selectAllFeatureFilesAndAggregates() throws MojoExecutionException {
        FeatureSelectionConfig config = new FeatureSelectionConfig();
        config.setFilesInclude("**/*.*");
        config.setIncludeClassifier("*");
        return this.getSelectedFeatures(config);
    }

    private void selectFeatureClassifier(String selection, Map<String, Feature> result) throws MojoExecutionException {
        Map<String, Feature> projectFeatures = ProjectHelper.getAssembledFeatures(this.project);
        boolean includeAll = "*".equals(selection);
        boolean found = false;
        for (Map.Entry<String, Feature> entry : projectFeatures.entrySet()) {
            String classifier = entry.getValue().getId().getClassifier();
            boolean include = includeAll;
            if (!include) {
                if (selection.trim().length() == 0 && classifier == null) {
                    include = true;
                } else if (selection.equals(classifier)) {
                    include = true;
                }
            }
            if (!include) continue;
            result.put(entry.getKey(), entry.getValue());
            found = true;
        }
        if (!found) {
            throw new MojoExecutionException("Aggregate Classifier " + selection + " not found.");
        }
    }

    private void selectFeatureFiles(String include, List<String> excludes, Map<String, Feature> result) throws MojoExecutionException {
        Map<String, Feature> projectFeatures = ProjectHelper.getAssembledFeatures(this.project);
        String prefix = this.features.toPath().normalize().toFile().getAbsolutePath().concat(File.separator);
        FeatureScanner scanner = new FeatureScanner(projectFeatures, prefix);
        if (!excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.setIncludes(new String[]{include});
        scanner.scan();
        if (!include.contains("*") && scanner.getIncluded().isEmpty()) {
            throw new MojoExecutionException("FeatureInclude " + include + " not found.");
        }
        for (Map.Entry<String, Feature> entry : scanner.getIncluded().entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        if (!excludes.isEmpty()) {
            for (String exclude : excludes) {
                if (exclude.contains("*")) continue;
                FeatureScanner excludeScanner = new FeatureScanner(projectFeatures, prefix);
                excludeScanner.setIncludes(new String[]{exclude});
                excludeScanner.scan();
                if (!excludeScanner.getIncluded().isEmpty()) continue;
                throw new MojoExecutionException("FeatureExclude " + exclude + " not found.");
            }
        }
    }

    private void selectRefsFiles(String selection, List<String> excludes, Map<String, Feature> result) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.project.getBasedir());
        if (!excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.setIncludes(new String[]{selection});
        scanner.scan();
        if (!selection.contains("*") && scanner.getIncludedFiles().length == 0) {
            throw new MojoExecutionException("RefsInclude " + selection + " not found.");
        }
        ArrayList<String> includedFiles = new ArrayList<String>(Arrays.asList(scanner.getIncludedFiles()));
        Collections.sort(includedFiles);
        for (String path : includedFiles) {
            File selectedFile = new File(this.project.getBasedir(), path.replace('/', File.separatorChar));
            try {
                List urls = IOUtils.parseFeatureRefFile((File)selectedFile);
                for (String url : urls) {
                    try {
                        ArtifactId id = ArtifactId.parse((String)url);
                        if (ProjectHelper.isLocalProjectArtifact(this.project, id)) {
                            throw new MojoExecutionException("RefsFile configuration is used to select a local feature: " + id.toMvnId());
                        }
                        Feature feature = ProjectHelper.getOrResolveFeature(this.project, this.mavenSession, this.artifactHandlerManager, this.repoSystem, id);
                        result.put(id.toMvnUrl(), feature);
                    }
                    catch (IllegalArgumentException e) {
                        throw new MojoExecutionException("Reference " + url + " in " + selectedFile.getAbsolutePath() + " is not a supported url.");
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private void selectFeatureArtifact(String artifactId, Map<String, Feature> result) throws MojoExecutionException {
        ArtifactId id = ArtifactId.parse((String)artifactId);
        if (ProjectHelper.isLocalProjectArtifact(this.project, id)) {
            throw new MojoExecutionException("FeatureArtifact configuration is used to select a local feature: " + id.toMvnId());
        }
        Feature feature = ProjectHelper.getOrResolveFeature(this.project, this.mavenSession, this.artifactHandlerManager, this.repoSystem, id);
        result.put(id.toMvnUrl(), feature);
    }

    public static class FeatureScanner
    extends AbstractScanner {
        private final Map<String, Feature> features;
        private final Map<String, Feature> included = new TreeMap<String, Feature>();
        private final String prefix;

        public FeatureScanner(Map<String, Feature> features, String prefix) {
            this.features = features;
            this.prefix = prefix;
        }

        public void scan() {
            this.setupDefaultFilters();
            this.setupMatchPatterns();
            for (Map.Entry<String, Feature> entry : this.features.entrySet()) {
                String[] tokenizedName;
                String name;
                if (ProjectHelper.isAggregate(entry.getKey()) || !this.isIncluded(name = entry.getKey().substring(this.prefix.length()), tokenizedName = FeatureScanner.tokenizePathToString(name, File.separator)) || this.isExcluded(name, tokenizedName)) continue;
                this.included.put(entry.getKey(), entry.getValue());
            }
        }

        static String[] tokenizePathToString(String path, String separator) {
            ArrayList<String> ret = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(path, separator);
            while (st.hasMoreTokens()) {
                ret.add(st.nextToken());
            }
            return ret.toArray(new String[ret.size()]);
        }

        public Map<String, Feature> getIncluded() {
            return this.included;
        }

        public String[] getIncludedFiles() {
            return null;
        }

        public String[] getIncludedDirectories() {
            return null;
        }

        public File getBasedir() {
            return null;
        }
    }
}

