/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005mw!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005BB \u0002\t\u0003\t\u0019\f\u0003\u0005@\u0003\u0005\u0005I\u0011QA\\\u0011%\ti,AI\u0001\n\u0003\t9\u0004C\u0005\u0002@\u0006\t\t\u0011\"!\u0002B\"I\u0011qZ\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003#\f\u0011\u0011!C\u0005\u0003'4AAM\u0012A\u0005\"AAJ\u0003BK\u0002\u0013\u0005Q\n\u0003\u0005O\u0015\tE\t\u0015!\u0003D\u0011!y%B!f\u0001\n\u0003\u0001\u0006\u0002\u0003+\u000b\u0005#\u0005\u000b\u0011B)\t\u000buRA\u0011A+\t\u000buRA\u0011\u0001-\t\u000buRA\u0011A.\t\u000buSA\u0011\t0\t\u000b)TA\u0011\u000b0\t\u000b-TA\u0011\t7\t\u000b-TA\u0011I<\t\u000fmT!\u0019!C!=\"1AP\u0003Q\u0001\n}CQ! \u0006\u0005RyD\u0011\"!\u0006\u000b\u0003\u0003%\t!a\u0006\t\u0013\u0005u!\"%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0015E\u0005I\u0011AA\u001c\u0011%\tYDCA\u0001\n\u0003\ni\u0004C\u0005\u0002N)\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0006\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003KR\u0011\u0011!C!\u0003OB\u0011\"!\u001e\u000b\u0003\u0003%\t!a\u001e\t\u0013\u0005\u0005%\"!A\u0005B\u0005\r\u0015AD*ue&tw\r\u0016:j[2+g\r\u001e\u0006\u0003I\u0015\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011aeJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001A\u0011\u0011'A\u0007\u0002G\tq1\u000b\u001e:j]\u001e$&/[7MK\u001a$8cA\u00015uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\u0004\"!N\u001e\n\u0005q2$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u00011\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\t\u0015QVAY!\t\t$bE\u0003\u000b\u0007\u001aK%\b\u0005\u00022\t&\u0011Qi\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u0019H\u0013\tA5EA\u000bTiJLgn\u001a\u001aUe&lW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005UR\u0015BA&7\u0005\u001d\u0001&o\u001c3vGR\faa\u001d:d'R\u0014X#A\"\u0002\u000fM\u00148m\u0015;sA\u00059AO]5n'R\u0014X#A)\u0011\u0007U\u00126)\u0003\u0002Tm\t1q\n\u001d;j_:\f\u0001\u0002\u001e:j[N#(\u000f\t\u000b\u0004\u0003Z;\u0006\"\u0002'\u0010\u0001\u0004\u0019\u0005bB(\u0010!\u0003\u0005\r!\u0015\u000b\u0004\u0003fS\u0006\"B(\u0011\u0001\u0004\u0019\u0005\"\u0002'\u0011\u0001\u0004\u0019ECA!]\u0011\u0015a\u0015\u00031\u0001D\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002?B\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"A\u0019\u001c\u000e\u0003\rT!\u0001Z\u0018\u0002\rq\u0012xn\u001c;?\u0013\t1g'\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u000147\u0003%!\u0017N]3di&|g.\u0001\u0004e_\u00163\u0018\r\u001c\u000b\u0003[V\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\u000bQL\b/Z:\u000b\u0005IL\u0013AB;og\u00064W-\u0003\u0002u_\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\t\u000bY$\u0002\u0019A7\u0002\u0013M\u00148m\u0015;sS:<GcA7ys\")a/\u0006a\u0001[\")!0\u0006a\u0001[\u0006QAO]5n'R\u0014\u0018N\\4\u0002\u0015Q\u0014\u0018.\\'fi\"|G-A\u0006ue&lW*\u001a;i_\u0012\u0004\u0013aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\t\tu\u0010C\u0004\u0002\u0002a\u0001\r!a\u0001\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0006\u0003\u000b\tya\u0011\b\u0005\u0003\u000f\tYAD\u0002c\u0003\u0013I\u0011aN\u0005\u0004\u0003\u001b1\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019B\u0001\u0006J]\u0012,\u00070\u001a3TKFT1!!\u00047\u0003\u0011\u0019w\u000e]=\u0015\u000b\u0005\u000bI\"a\u0007\t\u000f1K\u0002\u0013!a\u0001\u0007\"9q*\u0007I\u0001\u0002\u0004\t\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CQ3aQA\u0012W\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0018m\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003sQ3!UA\u0012\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0013\u0001\u00026bm\u0006L1\u0001[A\"\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0006E\u00026\u0003'J1!!\u00167\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY&!\u0019\u0011\u0007U\ni&C\u0002\u0002`Y\u00121!\u00118z\u0011%\t\u0019GHA\u0001\u0002\u0004\t\t&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0002b!a\u001b\u0002r\u0005mSBAA7\u0015\r\tyGN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA:\u0003[\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011PA@!\r)\u00141P\u0005\u0004\u0003{2$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003G\u0002\u0013\u0011!a\u0001\u00037\na!Z9vC2\u001cH\u0003BA=\u0003\u000bC\u0011\"a\u0019\"\u0003\u0003\u0005\r!a\u0017)/)\tI)a$\u0002\u0012\u0006U\u0015qSAN\u0003;\u000b\t+a)\u0002(\u0006%\u0006cA\u0019\u0002\f&\u0019\u0011QR\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111S\u0001G\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007e\u001d9bG\u0016\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u001a\u0006\tiB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ue&l7\u000b\u001e:![\u0001\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tAQ|\u0007\u0005\u001e:j[2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013\rI:j]\u001edW\rI:qC\u000e,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a(\u0002\u0017*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAV\u00031\u0019HO]5oO~3WO\\2t\u0011\u0019\tyk\u0001a\u0001\u0007\u0006\u00191\u000f\u001e:\t\u000b=\u001b\u0001\u0019A\"\u0015\u0007\u0005\u000b)\f\u0003\u0004\u00020\u0012\u0001\ra\u0011\u000b\u0006\u0003\u0006e\u00161\u0018\u0005\u0006\u0019\u0016\u0001\ra\u0011\u0005\b\u001f\u0016\u0001\n\u00111\u0001R\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fY\r\u0005\u00036%\u0006\u0015\u0007#B\u001b\u0002H\u000e\u000b\u0016bAAem\t1A+\u001e9mKJB\u0001\"!4\b\u0003\u0003\u0005\r!Q\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GCAAk!\u0011\t\t%a6\n\t\u0005e\u00171\t\u0002\u0007\u001f\nTWm\u0019;")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final String trimMethod;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public String direction() {
        return "LEADING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return srcString.trimLeft();
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return srcString.trimLeft(trimString);
    }

    @Override
    public String trimMethod() {
        return this.trimMethod;
    }

    @Override
    public StringTrimLeft withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcStr();
            }
            case 1: {
                return this.trimStr();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
        this.trimMethod = "trimLeft";
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

