/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TryToTimestampExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. The function always returns null on an invalid input with/without ANSI SQL\n      mode enabled. By default, it follows casting rules to a timestamp if the `fmt` is omitted.\n      The result data type is consistent with the value of configuration `spark.sql.timestampType`.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n      > SELECT _FUNC_('foo', 'yyyy-MM-dd');\n       NULL\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\nq\u0004\u0016:z)>$\u0016.\\3ti\u0006l\u0007/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s\u0015\t1q!A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0005\n\u0003!\u0019\u0017\r^1msN$(B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u0001\u0001CA\n\u0002\u001b\u0005)!a\b+ssR{G+[7fgR\fW\u000e]#yaJ,7o]5p]\n+\u0018\u000e\u001c3feN\u0019\u0011A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\ti\u0002%D\u0001\u001f\u0015\tyr!\u0001\u0005b]\u0006d\u0017p]5t\u0013\t\tcDA\tFqB\u0014Xm]:j_:\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#\u0001\n\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0007\u0019Jc\u0007\u0005\u0002\u0014O%\u0011\u0001&\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"\u0002\u0016\u0004\u0001\u0004Y\u0013\u0001\u00034v]\u000et\u0015-\\3\u0011\u00051\u001adBA\u00172!\tq\u0003$D\u00010\u0015\t\u0001\u0014#\u0001\u0004=e>|GOP\u0005\u0003ea\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\u0019\u0019FO]5oO*\u0011!\u0007\u0007\u0005\u0006\r\r\u0001\ra\u000e\t\u0004qu2cBA\u001d<\u001d\tq#(C\u0001\u001a\u0013\ta\u0004$A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$aA*fc*\u0011A\b\u0007\u0015\r\u0003\u0005#Ui\u0012%K\u00176s\u0005+\u0015\t\u0003'\tK!aQ\u0003\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\na)AB\r\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7q?N$(o\u0017\u0017!M6$X,\u000b\u0011.AA\u000b'o]3tAQDW\r\t1uS6,7\u000f^1na~\u001bHO\u001d1!Kb\u0004(/Z:tS>t\u0007e^5uQ\u0002\"\b.\u001a\u0011aM6$\b\rI3yaJ,7o]5p]*\u0001\u0003\u0005\t\u0011!AQ|\u0007%\u0019\u0011uS6,7\u000f^1na:\u0002C\u000b[3!MVt7\r^5p]\u0002\nGn^1zg\u0002\u0012X\r^;s]N\u0004c.\u001e7mA=t\u0007%\u00198!S:4\u0018\r\\5eA%t\u0007/\u001e;!o&$\bnL<ji\"|W\u000f\u001e\u0011B\u001dNK\u0005eU)M\u0015\u0001\u0002\u0003\u0005\t\u0011![>$W\rI3oC\ndW\r\u001a\u0018!\u0005f\u0004C-\u001a4bk2$H\u0006I5uA\u0019|G\u000e\\8xg\u0002\u001a\u0017m\u001d;j]\u001e\u0004#/\u001e7fg\u0002\"x\u000eI1!i&lWm\u001d;b[B\u0004\u0013N\u001a\u0011uQ\u0016\u0004\u0003MZ7uA\u0002J7\u000fI8nSR$X\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004#/Z:vYR\u0004C-\u0019;bAQL\b/\u001a\u0011jg\u0002\u001awN\\:jgR,g\u000e\u001e\u0011xSRD\u0007\u0005\u001e5fAY\fG.^3!_\u001a\u00043m\u001c8gS\u001e,(/\u0019;j_:\u0004\u0003m\u001d9be.t3/\u001d7/i&lWm\u001d;b[B$\u0016\u0010]3a])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\n\u0011*\u0001B\u001f\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C/[7fgR\fW\u000e]0tiJ\u0004S\u0006I!!gR\u0014\u0018N\\4!i>\u0004#-\u001a\u0011qCJ\u001cX\r\u001a\u0011u_\u0002\"\u0018.\\3ti\u0006l\u0007O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M6$\b%\f\u0011US6,7\u000f^1na\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u0004Co\u001c\u0011g_2dwn\u001e\u0018!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M\fH.\f:fM6\"\u0017\r^3uS6,W\u0006]1ui\u0016\u0014hN\f5u[2\u0014c\bR1uKRLW.\u001a\u0011QCR$XM\u001d8ty=\ng\b\t4pe\u00022\u0018\r\\5e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0011\fG/\u001a\u0011b]\u0012\u0004C/[7fA\u0019|'/\\1uAA\fG\u000f^3s]Nt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f\u0013\u0001T\u0001\u0002B*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE2T&\r\u001a.gE\u0002\u0003\u0007\r\u001e2ei\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\nt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0019|wn\n\u0017!OeL\u00180_\u0017N\u001b6\"GmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\nq*\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0003I\u000bQa\r\u00185]ABC\u0002A!E\u000b\u001eC%jS'O!F\u0003")
public final class TryToTimestampExpressionBuilder {
    public static Expression build(String string, Seq<Expression> seq) {
        return TryToTimestampExpressionBuilder$.MODULE$.build(string, (Seq)seq);
    }

    public static boolean supportsLambda() {
        return TryToTimestampExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature functionSignature, Seq<Expression> seq, String string) {
        return TryToTimestampExpressionBuilder$.MODULE$.rearrange(functionSignature, seq, string);
    }

    public static Option<FunctionSignature> functionSignature() {
        return TryToTimestampExpressionBuilder$.MODULE$.functionSignature();
    }
}

