/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="collection_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\")!\u000b\u0001C\u0001'\")a\u000b\u0001C!/\")\u0011\r\u0001C!E\")a\r\u0001C\u0005O\")1\u000e\u0001C!Y\"A!\u000f\u0001EC\u0002\u0013%1\u000fC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0016\u0001!I!a\u0006\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA\u001f\u0001\u0011E\u0013q\b\u0005\n\u0003\u000b\u0002\u0011\u0011!C\u0001\u0003\u000fB\u0011\"a\u0013\u0001#\u0003%\t!!\u0014\t\u0013\u0005\r\u0004!!A\u0005B\u0005\u0015\u0004\"CA;\u0001\u0005\u0005I\u0011AA<\u0011%\ty\bAA\u0001\n\u0003\t\t\tC\u0005\u0002\b\u0002\t\t\u0011\"\u0011\u0002\n\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003;\u0003\u0011\u0011!C!\u0003?C\u0011\"a)\u0001\u0003\u0003%\t%!*\b\u0013\u0005=w$!A\t\u0002\u0005Eg\u0001\u0003\u0010 \u0003\u0003E\t!a5\t\rICB\u0011AAv\u0011%\ti\u000fGA\u0001\n\u000b\ny\u000fC\u0005\u0002rb\t\t\u0011\"!\u0002t\"I\u0011q\u001f\r\u0002\u0002\u0013\u0005\u0015\u0011 \u0005\n\u0005\u000bA\u0012\u0011!C\u0005\u0005\u000f\u0011qAU3wKJ\u001cXM\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0019\u0001Q&\r\u001b<\u0003B\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011aFM\u0005\u0003g}\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003kar!A\f\u001c\n\u0005]z\u0012a\u00029bG.\fw-Z\u0005\u0003si\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u00028?A\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\"J\u001d\t\u0019\u0005J\u0004\u0002E\u000f6\tQI\u0003\u0002GW\u00051AH]8pizJ\u0011AP\u0005\u0003ouJ!AS&\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005]j\u0014!B2iS2$W#\u0001(\u0011\u00059z\u0015B\u0001) \u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t!V\u000b\u0005\u0002/\u0001!)Aj\u0001a\u0001\u001d\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003a\u00032AQ-\\\u0013\tQ6JA\u0002TKF\u0004\"\u0001X0\u000e\u0003uS!AX\u0012\u0002\u000bQL\b/Z:\n\u0005\u0001l&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A2\u0011\u0005q#\u0017BA3^\u0005!!\u0015\r^1UsB,\u0017A\u0007:fgVdG/\u0011:sCf,E.Z7f]RtU\u000f\u001c7bE2,W#\u00015\u0011\u0005qJ\u0017B\u00016>\u0005\u001d\u0011un\u001c7fC:\fAB\\;mYN\u000bg-Z#wC2$\"!\u001c9\u0011\u0005qr\u0017BA8>\u0005\r\te.\u001f\u0005\u0006c\u001e\u0001\r!\\\u0001\u0006S:\u0004X\u000f^\u0001\nI>\u0014VM^3sg\u0016,\u0012\u0001\u001e\t\u0005yUlW.\u0003\u0002w{\tIa)\u001e8di&|g.\r\u0015\u0003\u0011a\u0004\"\u0001P=\n\u0005il$!\u0003;sC:\u001c\u0018.\u001a8u\u0003%!wnR3o\u0007>$W\rF\u0003~\u0003\u000f\t\t\u0002E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003y\u0012aB2pI\u0016<WM\\\u0005\u0004\u0003\u000by(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005%\u0011\u00021\u0001\u0002\f\u0005\u00191\r\u001e=\u0011\u0007y\fi!C\u0002\u0002\u0010}\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0014%\u0001\r!`\u0001\u0003KZ\fQb\u001d;sS:<7i\u001c3f\u000f\u0016tGCBA\r\u0003S\tY\u0003\u0005\u0003\u0002\u001c\u0005\rb\u0002BA\u000f\u0003?\u0001\"\u0001R\u001f\n\u0007\u0005\u0005R(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\t9C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Ci\u0004BBA\n\u0015\u0001\u0007Q\u0010C\u0004\u0002.)\u0001\r!!\u0007\u0002\u0013\rD\u0017\u000e\u001c3OC6,\u0017\u0001D1se\u0006L8i\u001c3f\u000f\u0016tG\u0003CA\r\u0003g\t)$a\u000e\t\u000f\u0005%1\u00021\u0001\u0002\f!1\u00111C\u0006A\u0002uDq!!\f\f\u0001\u0004\tI\"\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0007\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r!\u0016\u0011\t\u0005\u0007\u0003\u0007j\u0001\u0019\u0001(\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019A+!\u0013\t\u000f1s\u0001\u0013!a\u0001\u001d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA(U\rq\u0015\u0011K\u0016\u0003\u0003'\u0002B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0005v]\u000eDWmY6fI*\u0019\u0011QL\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002b\u0005]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005!A.\u00198h\u0015\t\t\t(\u0001\u0003kCZ\f\u0017\u0002BA\u0013\u0003W\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001f\u0011\u0007q\nY(C\u0002\u0002~u\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!\\AB\u0011%\t)IEA\u0001\u0002\u0004\tI(A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0003R!!$\u0002\u00146l!!a$\u000b\u0007\u0005EU(\u0001\u0006d_2dWm\u0019;j_:LA!!&\u0002\u0010\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA\u00171\u0014\u0005\t\u0003\u000b#\u0012\u0011!a\u0001[\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9'!)\t\u0013\u0005\u0015U#!AA\u0002\u0005e\u0014AB3rk\u0006d7\u000fF\u0002i\u0003OC\u0001\"!\"\u0017\u0003\u0003\u0005\r!\u001c\u0015\u0018\u0001\u0005-\u0016\u0011WAZ\u0003o\u000bI,!0\u0002@\u0006\r\u0017QYAe\u0003\u0017\u00042ALAW\u0013\r\tyk\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t),A+`\rVs5i\u0018\u0015beJ\f\u00170\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E]3wKJ\u001cX\r\u001a\u0011tiJLgn\u001a\u0011pe\u0002\ng\u000eI1se\u0006L\be^5uQ\u0002\u0012XM^3sg\u0016\u0004sN\u001d3fe\u0002zg\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA^\u0003\u0005\r!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t'R'\u0002Z'/\u00199T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQIb\u0003%\r\u0017!i1\u00023'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u001bD\u0006\u000e\u00172YIj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0005\u0017\u0001E2pY2,7\r^5p]~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t9-A\u00032]Ur\u0003'\u0001\u0003o_R,\u0017EAAg\u0003iR\u0001\u0005\t\u0011!%\u00164XM]:fA1|w-[2!M>\u0014\b%\u0019:sCf\u001c\b%[:!CZ\f\u0017\u000e\\1cY\u0016\u00043/\u001b8dK\u0002\u0012d\u0006\u000e\u00181])\u0001\u0003%A\u0004SKZ,'o]3\u0011\u00059B2#\u0002\r\u0002V\u0006\u0005\bCBAl\u0003;tE+\u0004\u0002\u0002Z*\u0019\u00111\\\u001f\u0002\u000fI,h\u000e^5nK&!\u0011q\\Am\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003G\fI/\u0004\u0002\u0002f*!\u0011q]A8\u0003\tIw.C\u0002K\u0003K$\"!!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001a\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007Q\u000b)\u0010C\u0003M7\u0001\u0007a*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005m(\u0011\u0001\t\u0005y\u0005uh*C\u0002\u0002\u0000v\u0012aa\u00149uS>t\u0007\u0002\u0003B\u00029\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\nA!\u0011\u0011\u000eB\u0006\u0013\u0011\u0011i!a\u001b\u0003\r=\u0013'.Z2u\u0001")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse x$0) {
        return Reverse$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> g) {
        return Reverse$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Reverse> compose(Function1<A$, Expression> g) {
        return Reverse$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))));
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable)x$19 -> ((UTF8String)x$19).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        return !this.bitmap$trans$0 ? this.doReverse$lzycompute() : this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            String string;
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                string = this.stringCodeGen(ev, (String)c);
            } else if (dataType instanceof ArrayType) {
                string = this.arrayCodeGen(ctx, ev, (String)c);
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, this.resultArrayElementNullable());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString()));
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    @Override
    public Reverse withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

