/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.ToUnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(timeExp[, fmt]) - Returns the UNIX timestamp of the given time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string which is returned as a UNIX timestamp.\n      * fmt - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n              Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460098800\n  ", group="datetime_funcs", since="1.6.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0015*\u0001ZB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u00031\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B,\t\u0011\r\u0004!Q3A\u0005\u0002\u0011D\u0001\u0002\u001b\u0001\u0003\u0012\u0003\u0006I!\u001a\u0005\u0006S\u0002!\tA\u001b\u0005\u0006S\u0002!\t\u0001\u001d\u0005\u0006g\u0002!\tE\u0014\u0005\u0006i\u0002!\tE\u0014\u0005\u0006k\u0002!\tE\u001e\u0005\u0006S\u0002!\ta\u001f\u0005\u0006}\u0002!\te \u0005\b\u0003\u0003\u0001A\u0011KA\u0002\u0011%\ti\u0001AA\u0001\n\u0003\ty\u0001C\u0005\u0002\u001a\u0001\t\n\u0011\"\u0001\u0002\u001c!I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003kA\u0011\"!\u000f\u0001#\u0003%\t!a\u000f\t\u0013\u0005}\u0002!!A\u0005B\u0005\u0005\u0003\"CA)\u0001\u0005\u0005I\u0011AA*\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003C\u0011\"!\"\u0001\u0003\u0003%\t%a\"\b\u0013\u0005E\u0016&!A\t\u0002\u0005Mf\u0001\u0003\u0015*\u0003\u0003E\t!!.\t\r%tB\u0011AAg\u0011%\tyMHA\u0001\n\u000b\n\t\u000eC\u0005\u0002Tz\t\t\u0011\"!\u0002V\"I\u0011q\u001c\u0010\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003Ct\u0012\u0013!C\u0001\u0003wA\u0011\"a9\u001f\u0003\u0003%\t)!:\t\u0013\u0005Mh$%A\u0005\u0002\u0005U\u0002\"CA{=E\u0005I\u0011AA\u001e\u0011%\t9PHA\u0001\n\u0013\tIPA\bU_Vs\u0017\u000e\u001f+j[\u0016\u001cH/Y7q\u0015\tQ3&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0017.\u0003!\u0019\u0017\r^1msN$(B\u0001\u00180\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO\u000e\u00011\u0003\u0002\u00018w\u0005\u0003\"\u0001O\u001d\u000e\u0003%J!AO\u0015\u0003\u0011Us\u0017\u000e\u001f+j[\u0016\u0004\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002C\u0015:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\rV\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005%k\u0014a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!S\u001f\u0002\u000fQLW.Z#yaV\tq\n\u0005\u00029!&\u0011\u0011+\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u0003;j[\u0016,\u0005\u0010\u001d\u0011\u0002\r\u0019|'/\\1u\u0003\u001d1wN]7bi\u0002\n!\u0002^5nKj{g.Z%e+\u00059\u0006c\u0001\u001fY5&\u0011\u0011,\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005m{fB\u0001/^!\t!U(\u0003\u0002_{\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tqV(A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012!\u001a\t\u0003y\u0019L!aZ\u001f\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"Ra\u001b7n]>\u0004\"\u0001\u000f\u0001\t\u000b5K\u0001\u0019A(\t\u000bMK\u0001\u0019A(\t\u000fUK\u0001\u0013!a\u0001/\"91-\u0003I\u0001\u0002\u0004)GcA6re\")QJ\u0003a\u0001\u001f\")1K\u0003a\u0001\u001f\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\t9(\u0010\u0005\u00029q&\u0011\u00110\u000b\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:DQ!V\u0007A\u0002i#\"a\u001b?\t\u000but\u0001\u0019A(\u0002\tQLW.Z\u0001\u000baJ,G\u000f^=OC6,W#\u0001.\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B6\u0002\u0006\u0005%\u0001BBA\u0004!\u0001\u0007q*A\u0004oK^dUM\u001a;\t\r\u0005-\u0001\u00031\u0001P\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$\u0012b[A\t\u0003'\t)\"a\u0006\t\u000f5\u000b\u0002\u0013!a\u0001\u001f\"91+\u0005I\u0001\u0002\u0004y\u0005bB+\u0012!\u0003\u0005\ra\u0016\u0005\bGF\u0001\n\u00111\u0001f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\b+\u0007=\u000byb\u000b\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!C;oG\",7m[3e\u0015\r\tY#P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00028)\u001aq+a\b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\b\u0016\u0004K\u0006}\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00027b]\u001eT!!!\u0014\u0002\t)\fg/Y\u0005\u0004A\u0006\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\ra\u0014qK\u0005\u0004\u00033j$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA0\u0003K\u00022\u0001PA1\u0013\r\t\u0019'\u0010\u0002\u0004\u0003:L\b\"CA41\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000e\t\u0007\u0003_\n)(a\u0018\u000e\u0005\u0005E$bAA:{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0014\u0011\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002f\u0003{B\u0011\"a\u001a\u001b\u0003\u0003\u0005\r!a\u0018\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\n\u0019\tC\u0005\u0002hm\t\t\u00111\u0001\u0002V\u00051Q-];bYN$2!ZAE\u0011%\t9\u0007HA\u0001\u0002\u0004\ty\u0006K\f\u0001\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9+a+\u0002.B\u0019\u0001(a$\n\u0007\u0005E\u0015FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0015AR0G+:\u001bu\f\u000b;j[\u0016,\u0005\u0010].-A\u0019lG/X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!+:K\u0005\f\t;j[\u0016\u001cH/Y7qA=4\u0007\u0005\u001e5fA\u001dLg/\u001a8!i&lWML\u0001\nCJ<W/\\3oiN\f#!!(\u0002\u0007KQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016,\u0005\u0010\u001d\u0011.A\u0005\u0003C-\u0019;f_QLW.Z:uC6\u0004\be\u001c:!gR\u0014\u0018N\\4!o\"L7\r\u001b\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%Y:!C\u0002*f*\u0013-!i&lWm\u001d;b[Bt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I%h]>\u0014X\r\u001a\u0011jM\u0002\u0002G/[7f\u000bb\u0004\b\rI5tA9|G\u000fI1!gR\u0014\u0018N\\4/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0011+g-Y;mi\u00022\u0018\r\\;fA%\u001c\bEI=zsflS*T\u0017eI\u0002B\u0005JO7nuM\u001c(E\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8sAY\fG.\u001b3!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111U\u0001W\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[A\"T\u0006\r\u001d(Y\u0001:\u00130_=z[5kU\u0006\u001a3(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\u000e\u001c1aeB\u0004\b\r\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!+\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011qV\u0001\u0006c92d\u0006M\u0001\u0010)>,f.\u001b=US6,7\u000f^1naB\u0011\u0001HH\n\u0006=\u0005]\u00161\u0019\t\n\u0003s\u000bylT(XK.l!!a/\u000b\u0007\u0005uV(A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00171\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003BAc\u0003\u0017l!!a2\u000b\t\u0005%\u00171J\u0001\u0003S>L1aSAd)\t\t\u0019,\u0001\u0005u_N#(/\u001b8h)\t\t\u0019%A\u0003baBd\u0017\u0010F\u0005l\u0003/\fI.a7\u0002^\")Q*\ta\u0001\u001f\")1+\ta\u0001\u001f\"9Q+\tI\u0001\u0002\u00049\u0006bB2\"!\u0003\u0005\r!Z\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u001d\u0018q\u001e\t\u0005ya\u000bI\u000fE\u0004=\u0003W|ujV3\n\u0007\u00055XH\u0001\u0004UkBdW\r\u000e\u0005\t\u0003c$\u0013\u0011!a\u0001W\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111 \t\u0005\u0003\u000b\ni0\u0003\u0003\u0002\u0000\u0006\u001d#AB(cU\u0016\u001cG\u000f")
public class ToUnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ToUnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(ToUnixTimestamp x$0) {
        return ToUnixTimestamp$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ToUnixTimestamp$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return ToUnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, ToUnixTimestamp> tupled() {
        return ToUnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, ToUnixTimestamp>>>> curried() {
        return ToUnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public String prettyName() {
        return "to_unix_timestamp";
    }

    @Override
    public ToUnixTimestamp withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public ToUnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        return new ToUnixTimestamp(timeExp, format, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ToUnixTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeExp();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToUnixTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "timeExp";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            case 3: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToUnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToUnixTimestamp toUnixTimestamp = (ToUnixTimestamp)x$1;
        if (this.failOnError() != toUnixTimestamp.failOnError()) return false;
        Expression expression = this.timeExp();
        Expression expression2 = toUnixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = toUnixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = toUnixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toUnixTimestamp.canEqual(this)) return false;
        return true;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
    }

    public ToUnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public ToUnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

