/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TBinaryColumn;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRow;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.HiveResult;
import org.apache.spark.sql.execution.HiveResult$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

public final class RowSetUtils$ {
    public static final RowSetUtils$ MODULE$ = new RowSetUtils$();

    public ByteBuffer bitSetToBuffer(BitSet bitSet) {
        return ByteBuffer.wrap(bitSet.toByteArray());
    }

    public TRowSet toTRowSet(long startRowOffSet, scala.collection.immutable.Seq<Row> rows, DataType[] schema, TProtocolVersion protocolVersion, HiveResult.TimeFormatters timeFormatters) {
        return protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue() ? this.toRowBasedSet(startRowOffSet, rows, schema, timeFormatters) : this.toColumnBasedSet(startRowOffSet, rows, schema, timeFormatters);
    }

    private TRowSet toRowBasedSet(long startRowOffSet, scala.collection.immutable.Seq<Row> rows, DataType[] schema, HiveResult.TimeFormatters timeFormatters) {
        List tRows = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)rows.map((Function1 & Serializable)row -> {
            void var3_3;
            TRow tRow = new TRow();
            int columnSize = row.length();
            for (int j = 0; j < columnSize; ++j) {
                TColumnValue columnValue = MODULE$.toTColumnValue(j, (Row)row, schema[j], timeFormatters);
                tRow.addToColVals(columnValue);
            }
            return var3_3;
        })).asJava();
        return new TRowSet(startRowOffSet, tRows);
    }

    private TRowSet toColumnBasedSet(long startRowOffSet, scala.collection.immutable.Seq<Row> rows, DataType[] schema, HiveResult.TimeFormatters timeFormatters) {
        int rowSize = rows.length();
        TRowSet tRowSet = new TRowSet(startRowOffSet, new ArrayList(rowSize));
        int columnSize = schema.length;
        for (int i = 0; i < columnSize; ++i) {
            TColumn tColumn = this.toTColumn(rows, i, schema[i], timeFormatters);
            tRowSet.addToColumns(tColumn);
        }
        return tRowSet;
    }

    private TColumn toTColumn(scala.collection.immutable.Seq<Row> rows, int ordinal, DataType typ, HiveResult.TimeFormatters timeFormatters) {
        TColumn tColumn;
        BitSet nulls = new BitSet();
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType)) {
            List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
            tColumn = TColumn.boolVal((TBoolColumn)new TBoolColumn(values, this.bitSetToBuffer(nulls)));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
            tColumn = TColumn.byteVal((TByteColumn)new TByteColumn(values, this.bitSetToBuffer(nulls)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
            tColumn = TColumn.i16Val((TI16Column)new TI16Column(values, this.bitSetToBuffer(nulls)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
            tColumn = TColumn.i32Val((TI32Column)new TI32Column(values, this.bitSetToBuffer(nulls)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
            tColumn = TColumn.i64Val((TI64Column)new TI64Column(values, this.bitSetToBuffer(nulls)));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable)n -> Double.valueOf(n.toString()))).asJava();
            tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, this.bitSetToBuffer(nulls)));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
            tColumn = TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, this.bitSetToBuffer(nulls)));
        } else if (StringType$.MODULE$.equals(dataType)) {
            List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
            tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, this.bitSetToBuffer(nulls)));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))).asScala()).map((Function1 & Serializable)x$1 -> ByteBuffer.wrap(x$1))).asJava();
            tColumn = TColumn.binaryVal((TBinaryColumn)new TBinaryColumn(values, this.bitSetToBuffer(nulls)));
        } else {
            IntRef i = IntRef.create((int)0);
            int rowSize = rows.length();
            ArrayList values = new ArrayList(rowSize);
            rows.foreach((Function1 & Serializable)row -> {
                RowSetUtils$.$anonfun$toTColumn$3(nulls, i, ordinal, typ, timeFormatters, values, row);
                return BoxedUnit.UNIT;
            });
            tColumn = TColumn.stringVal((TStringColumn)new TStringColumn(values, this.bitSetToBuffer(nulls)));
        }
        return tColumn;
    }

    private <T> List<T> getOrSetAsNull(scala.collection.immutable.Seq<Row> rows, int ordinal, BitSet nulls, T defaultVal) {
        int size = rows.length();
        ArrayList ret = new ArrayList(size);
        IntRef idx = IntRef.create((int)0);
        rows.foreach((Function1 & Serializable)row -> {
            RowSetUtils$.$anonfun$getOrSetAsNull$1(ordinal, nulls, idx, ret, defaultVal, row);
            return BoxedUnit.UNIT;
        });
        return ret;
    }

    private TColumnValue toTColumnValue(int ordinal, Row row, DataType dataType, HiveResult.TimeFormatters timeFormatters) {
        TColumnValue tColumnValue;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            TBoolValue boolValue = new TBoolValue();
            if (!row.isNullAt(ordinal)) {
                boolValue.setValue(row.getBoolean(ordinal));
            }
            tColumnValue = TColumnValue.boolVal((TBoolValue)boolValue);
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            TByteValue byteValue = new TByteValue();
            if (!row.isNullAt(ordinal)) {
                byteValue.setValue(row.getByte(ordinal));
            }
            tColumnValue = TColumnValue.byteVal((TByteValue)byteValue);
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            TI16Value tI16Value = new TI16Value();
            if (!row.isNullAt(ordinal)) {
                tI16Value.setValue(row.getShort(ordinal));
            }
            tColumnValue = TColumnValue.i16Val((TI16Value)tI16Value);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            TI32Value tI32Value = new TI32Value();
            if (!row.isNullAt(ordinal)) {
                tI32Value.setValue(row.getInt(ordinal));
            }
            tColumnValue = TColumnValue.i32Val((TI32Value)tI32Value);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            TI64Value tI64Value = new TI64Value();
            if (!row.isNullAt(ordinal)) {
                tI64Value.setValue(row.getLong(ordinal));
            }
            tColumnValue = TColumnValue.i64Val((TI64Value)tI64Value);
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (!row.isNullAt(ordinal)) {
                Double doubleValue = Double.valueOf(Float.toString(row.getFloat(ordinal)));
                tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
            }
            tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            TDoubleValue tDoubleValue = new TDoubleValue();
            if (!row.isNullAt(ordinal)) {
                tDoubleValue.setValue(row.getDouble(ordinal));
            }
            tColumnValue = TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            TStringValue tStringValue = new TStringValue();
            if (!row.isNullAt(ordinal)) {
                tStringValue.setValue(row.getString(ordinal));
            }
            tColumnValue = TColumnValue.stringVal((TStringValue)tStringValue);
        } else {
            TStringValue tStrValue = new TStringValue();
            if (!row.isNullAt(ordinal)) {
                String value = HiveResult$.MODULE$.toHiveString(new Tuple2(row.get(ordinal), (Object)dataType), false, timeFormatters);
                tStrValue.setValue(value);
            }
            tColumnValue = TColumnValue.stringVal((TStringValue)tStrValue);
        }
        return tColumnValue;
    }

    public static final /* synthetic */ void $anonfun$toTColumn$3(BitSet nulls$1, IntRef i$1, int ordinal$1, DataType typ$1, HiveResult.TimeFormatters timeFormatters$2, ArrayList values$1, Row row) {
        nulls$1.set(i$1.elem, row.isNullAt(ordinal$1));
        String value = row.isNullAt(ordinal$1) ? "" : HiveResult$.MODULE$.toHiveString(new Tuple2(row.get(ordinal$1), (Object)typ$1), true, timeFormatters$2);
        values$1.add(value);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$getOrSetAsNull$1(int ordinal$2, BitSet nulls$2, IntRef idx$1, ArrayList ret$1, Object defaultVal$1, Row row) {
        if (row.isNullAt(ordinal$2)) {
            nulls$2.set(idx$1.elem, true);
            ret$1.add(idx$1.elem, defaultVal$1);
        } else {
            ret$1.add(idx$1.elem, row.getAs(ordinal$2));
        }
        ++idx$1.elem;
    }

    private RowSetUtils$() {
    }
}

