/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Formats the number `expr1` like '#,###,###.##', rounded to `expr2`\n      decimal places. If `expr2` is 0, the result has no decimal point or fractional part.\n      `expr2` also accept a user specified format.\n      This is supposed to function like MySQL's FORMAT.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(12332.123456, 4);\n       12,332.1235\n      > SELECT _FUNC_(12332.123456, '##################.###');\n       12332.123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tec\u0001\u0002\u0016,\u0001bB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015\u0011\u0007\u0001\"\u0011W\u0011\u0015\u0019\u0007\u0001\"\u0011W\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015I\u0007\u0001\"\u0011f\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u001d)\bA1A\u0005\nYDaa \u0001!\u0002\u00139\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0015BA\u0003\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY\u0003C\u0005\u0002>\u0001\u0001\r\u0011\"\u0003\u0002@!A\u00111\t\u0001!B\u0013\ti\u0003\u0003\u0006\u0002H\u0001A)\u0019!C\u0005\u0003\u0013B!\"a\u0015\u0001\u0011\u000b\u0007I\u0011BA+\u0011\u001d\t)\u0007\u0001C)\u0003OBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\u0016\u0002!\t%a&\t\u000f\u0005e\u0005\u0001\"\u0015\u0002\u001c\"I\u0011Q\u0015\u0001\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003[\u0003\u0011\u0013!C\u0001\u0003_C\u0011\"!2\u0001#\u0003%\t!a,\t\u0011\u0005\u001d\u0007!!A\u0005BYD\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u00055\u0007!!A\u0005\u0002\u0005=\u0007\"CAj\u0001\u0005\u0005I\u0011IAk\u0011%\t\u0019\u000fAA\u0001\n\u0003\t)\u000fC\u0005\u0002j\u0002\t\t\u0011\"\u0011\u0002l\"I\u0011q\u001e\u0001\u0002\u0002\u0013\u0005\u0013\u0011_\u0004\n\u0005+Y\u0013\u0011!E\u0001\u0005/1\u0001BK\u0016\u0002\u0002#\u0005!\u0011\u0004\u0005\u0007;\u0012\"\tA!\r\t\u0013\tMB%!A\u0005F\tU\u0002\"\u0003B\u001cI\u0005\u0005I\u0011\u0011B\u001d\u0011%\u0011y\u0004JA\u0001\n\u0003\u0013\t\u0005C\u0005\u0003P\u0011\n\t\u0011\"\u0003\u0003R\taai\u001c:nCRtU/\u001c2fe*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001su\u00025)\u0013\t\u0003umj\u0011aK\u0005\u0003y-\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003u\u0005K!AQ\u0016\u0003A\u0011+g-Y;miN#(/\u001b8h!J|G-^2j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\b!J|G-^2u!\tQ%K\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011ajN\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K!!U#\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003#\u0016\u000b\u0011\u0001_\u000b\u0002/B\u0011!\bW\u0005\u00033.\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\tA\b%A\u0001e\u0003\t!\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004?\u0002\f\u0007C\u0001\u001e\u0001\u0011\u0015)V\u00011\u0001X\u0011\u0015YV\u00011\u0001X\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u00119,H\u000e\\1cY\u0016,\u0012A\u001a\t\u0003\t\u001eL!\u0001[#\u0003\u000f\t{w\u000e\\3b]\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$\u0018AC5oaV$H+\u001f9fgV\tA\u000eE\u0002K[>L!A\u001c+\u0003\u0007M+\u0017\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002s_\u0005)A/\u001f9fg&\u0011A/\u001d\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fQ\u0002Z3gCVdGOR8s[\u0006$X#A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018\u0001\u00027b]\u001eT\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fs\n11\u000b\u001e:j]\u001e\fa\u0002Z3gCVdGOR8s[\u0006$\b%A\u0007mCN$H)\u00138u-\u0006dW/Z\u000b\u0003\u0003\u000b\u0001R\u0001RA\u0004\u0003\u0017I1!!\u0003F\u0005\u0019y\u0005\u000f^5p]B\u0019A)!\u0004\n\u0007\u0005=QIA\u0002J]R\f\u0011\u0003\\1ti\u0012Ke\u000e\u001e,bYV,w\fJ3r)\u0011\t)\"a\u0007\u0011\u0007\u0011\u000b9\"C\u0002\u0002\u001a\u0015\u0013A!\u00168ji\"I\u0011Q\u0004\b\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0014A\u00047bgR$\u0015J\u001c;WC2,X\r\t\u0015\u0004\u001f\u0005\r\u0002c\u0001#\u0002&%\u0019\u0011qE#\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00057bgR$5\u000b\u001e:j]\u001e4\u0016\r\\;f+\t\ti\u0003E\u0003E\u0003\u000f\ty\u0003\u0005\u0003\u00022\u0005eb\u0002BA\u001a\u0003k\u0001\"\u0001T#\n\u0007\u0005]R)\u0001\u0004Qe\u0016$WMZ\u0005\u0004}\u0006m\"bAA\u001c\u000b\u0006!B.Y:u\tN#(/\u001b8h-\u0006dW/Z0%KF$B!!\u0006\u0002B!I\u0011QD\t\u0002\u0002\u0003\u0007\u0011QF\u0001\u0012Y\u0006\u001cH\u000fR*ue&twMV1mk\u0016\u0004\u0003f\u0001\n\u0002$\u00059\u0001/\u0019;uKJtWCAA&!\rA\u0018QJ\u0005\u0004\u0003\u001fJ(\u0001D*ue&twMQ;gM\u0016\u0014\bfA\n\u0002$\u0005aa.^7cKJ4uN]7biV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL>\u0002\tQ,\u0007\u0010^\u0005\u0005\u0003C\nYFA\u0007EK\u000eLW.\u00197G_Jl\u0017\r\u001e\u0015\u0004)\u0005\r\u0012\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA5\u0003_\n\u0019\bE\u0002E\u0003WJ1!!\u001cF\u0005\r\te.\u001f\u0005\b\u0003c*\u0002\u0019AA5\u0003\u001dAxJ\u00196fGRDq!!\u001e\u0016\u0001\u0004\tI'A\u0004e\u001f\nTWm\u0019;\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA>\u0003\u000f\u000b\t\n\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tiK\u0001\bG>$WmZ3o\u0013\u0011\t))a \u0003\u0011\u0015C\bO]\"pI\u0016Dq!!#\u0017\u0001\u0004\tY)A\u0002dib\u0004B!! \u0002\u000e&!\u0011qRA@\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a%\u0017\u0001\u0004\tY(\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005=\u0012aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015y\u0016QTAQ\u0011\u0019\ty\n\u0007a\u0001/\u00069a.Z<MK\u001a$\bBBAR1\u0001\u0007q+\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000b}\u000bI+a+\t\u000fUK\u0002\u0013!a\u0001/\"91,\u0007I\u0001\u0002\u00049\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cS3aVAZW\t\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\u0013Ut7\r[3dW\u0016$'bAA`\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0017\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003S\n\t\u000eC\u0005\u0002\u001ey\t\t\u00111\u0001\u0002\f\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002XB1\u0011\u0011\\Ap\u0003Sj!!a7\u000b\u0007\u0005uW)\u0001\u0006d_2dWm\u0019;j_:LA!!9\u0002\\\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r1\u0017q\u001d\u0005\n\u0003;\u0001\u0013\u0011!a\u0001\u0003S\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019q/!<\t\u0013\u0005u\u0011%!AA\u0002\u0005-\u0011AB3rk\u0006d7\u000fF\u0002g\u0003gD\u0011\"!\b#\u0003\u0003\u0005\r!!\u001b)'\u0001\t90!@\u0002\u0000\n\r!Q\u0001B\u0005\u0005\u0017\u0011yA!\u0005\u0011\u0007i\nI0C\u0002\u0002|.\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0002\u0005\u0011yE\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3S\u0001j\u0003ER8s[\u0006$8\u000f\t;iK\u0002rW/\u001c2fe\u0002\u0002W\r\u001f9sc\u0001\u0004C.[6fA\u001d\u001aCfI\u0012$Y\r\u001a3EL\u0012$O1\u0002#o\\;oI\u0016$\u0007\u0005^8!A\u0016D\bO\u001d\u001aa\u0015\u0001\u0002\u0003\u0005\t\u0011!I\u0016\u001c\u0017.\\1mAAd\u0017mY3t]\u0001Je\r\t1fqB\u0014(\u0007\u0019\u0011jg\u0002\u0002D\u0006\t;iK\u0002\u0012Xm];mi\u0002B\u0017m\u001d\u0011o_\u0002\"WmY5nC2\u0004\u0003o\\5oi\u0002z'\u000f\t4sC\u000e$\u0018n\u001c8bY\u0002\u0002\u0018M\u001d;/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0016D\bO\u001d\u001aaA\u0005d7o\u001c\u0011bG\u000e,\u0007\u000f\u001e\u0011bAU\u001cXM\u001d\u0011ta\u0016\u001c\u0017NZ5fI\u00022wN]7bi:R\u0001\u0005\t\u0011!A\u0001\"\u0006.[:!SN\u00043/\u001e9q_N,G\r\t;pA\u0019,hn\u0019;j_:\u0004C.[6fA5K8+\u0015'(g\u00022uJU'B):R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qA\u0001\u0002:)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013GM\u001a4e9\n$g\r\u001b6m1\u0002C'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cIb3g\r\u001a/cI\u001aTG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152eM\u001a$GL\u00193gQ*d\u0007\f\u0011(G\r\u001a3eI\u0012$G\r\u001a3eI\u0012$G\r\u001a3EL\u0012$G\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00193gM\u0012d&\r\u001a4\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u0007\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\u0011\u0019\"\u0001\u0007tiJLgnZ0gk:\u001c7/\u0001\u0007G_Jl\u0017\r\u001e(v[\n,'\u000f\u0005\u0002;IM)AEa\u0007\u0003(A9!Q\u0004B\u0012/^{VB\u0001B\u0010\u0015\r\u0011\t#R\u0001\beVtG/[7f\u0013\u0011\u0011)Ca\b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0003*\t=RB\u0001B\u0016\u0015\r\u0011ic_\u0001\u0003S>L1a\u0015B\u0016)\t\u00119\"\u0001\u0005u_N#(/\u001b8h)\u00059\u0018!B1qa2LH#B0\u0003<\tu\u0002\"B+(\u0001\u00049\u0006\"B.(\u0001\u00049\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0007\u0012Y\u0005E\u0003E\u0003\u000f\u0011)\u0005E\u0003E\u0005\u000f:v+C\u0002\u0003J\u0015\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B'Q\u0005\u0005\t\u0019A0\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003TA\u0019\u0001P!\u0016\n\u0007\t]\u0013P\u0001\u0004PE*,7\r\u001e")
public class FormatNumber
extends BinaryExpression
implements ExpectsInputTypes,
DefaultStringProducingExpression,
Serializable {
    private transient StringBuffer pattern;
    private transient DecimalFormat numberFormat;
    private final Expression x;
    private final Expression d;
    private final String defaultFormat;
    private transient Option<Object> lastDIntValue;
    private transient Option<String> lastDStringValue;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FormatNumber x$0) {
        return FormatNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FormatNumber> tupled() {
        return FormatNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FormatNumber>> curried() {
        return FormatNumber$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression d() {
        return this.d;
    }

    @Override
    public Expression left() {
        return this.x();
    }

    @Override
    public Expression right() {
        return this.d();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())})), (List)Nil$.MODULE$));
    }

    private String defaultFormat() {
        return this.defaultFormat;
    }

    private Option<Object> lastDIntValue() {
        return this.lastDIntValue;
    }

    private void lastDIntValue_$eq(Option<Object> x$1) {
        this.lastDIntValue = x$1;
    }

    private Option<String> lastDStringValue() {
        return this.lastDStringValue;
    }

    private void lastDStringValue_$eq(Option<String> x$1) {
        this.lastDStringValue = x$1;
    }

    private StringBuffer pattern$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pattern = new StringBuffer();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.pattern;
    }

    private StringBuffer pattern() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.pattern$lzycompute();
        }
        return this.pattern;
    }

    private DecimalFormat numberFormat$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numberFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numberFormat;
    }

    private DecimalFormat numberFormat() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.numberFormat$lzycompute();
        }
        return this.numberFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object nullSafeEval(Object xObject, Object dObject) {
        block17: {
            block18: {
                block16: {
                    var7_3 = this.right().dataType();
                    if (!IntegerType$.MODULE$.equals(var7_3)) break block16;
                    dValue = BoxesRunTime.unboxToInt((Object)dObject);
                    if (dValue < 0) {
                        return null;
                    }
                    var9_5 = this.lastDIntValue();
                    if (var9_5 instanceof Some && (last = BoxesRunTime.unboxToInt((Object)(var10_6 = (Some)var9_5).value())) == dValue) {
                    } else {
                        this.pattern().delete(0, this.pattern().length());
                        this.pattern().append(this.defaultFormat());
                        if (dValue > 0) {
                            this.pattern().append(".");
                            for (i = 0; i < dValue; ++i) {
                                this.pattern().append("0");
                            }
                        }
                        this.lastDIntValue_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dValue)));
                        this.numberFormat().applyLocalizedPattern(this.pattern().toString());
                    }
                    break block17;
                }
                if (!(var7_3 instanceof StringType)) break block18;
                dValue = ((UTF8String)dObject).toString();
                var14_10 = this.lastDStringValue();
                if (!(var14_10 instanceof Some)) ** GOTO lbl-1000
                var15_11 = (Some)var14_10;
                v0 = last = (String)var15_11.value();
                var17_13 = dValue;
                if (!(v0 != null ? v0.equals(var17_13) == false : var17_13 != null)) {
                } else lbl-1000:
                // 2 sources

                {
                    this.pattern().delete(0, this.pattern().length());
                    this.lastDStringValue_$eq((Option<String>)new Some((Object)dValue));
                    if (dValue.isEmpty()) {
                        this.numberFormat().applyLocalizedPattern(this.defaultFormat());
                    } else {
                        this.numberFormat().applyLocalizedPattern(dValue);
                    }
                }
                break block17;
            }
            throw new MatchError((Object)var7_3);
        }
        var18_14 = this.x().dataType();
        if (ByteType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToByte((Object)xObject)));
        }
        if (ShortType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToShort((Object)xObject)));
        }
        if (FloatType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToFloat((Object)xObject)));
        }
        if (IntegerType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToInt((Object)xObject)));
        }
        if (LongType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToLong((Object)xObject)));
        }
        if (DoubleType$.MODULE$.equals(var18_14)) {
            return UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToDouble((Object)xObject)));
        }
        if (var18_14 instanceof DecimalType) {
            return UTF8String.fromString((String)this.numberFormat().format(((Decimal)xObject).toJavaBigDecimal()));
        }
        throw new MatchError((Object)var18_14);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(num, d) -> {
            String sb = StringBuffer.class.getName();
            String df = DecimalFormat.class.getName();
            String dfs = DecimalFormatSymbols.class.getName();
            String l = Locale.class.getName();
            String usLocale = "US";
            String numberFormat = ctx.addMutableState(df, "numberFormat", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + df + "(\"\", new " + dfs + "(" + l + "." + usLocale + "));", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
            DataType dataType = this.right().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                String pattern = ctx.addMutableState(sb, "pattern", (Function1<String, String>)(Function1 & Serializable)v -> v + " = new " + sb + "();", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String i = ctx.freshName("i");
                String lastDValue = ctx.addMutableState("int", "lastDValue", (Function1<String, String>)(Function1 & Serializable)v -> v + " = -100;", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                return "\n            if (" + d + " >= 0) {\n              " + pattern + ".delete(0, " + pattern + ".length());\n              if (" + d + " != " + lastDValue + ") {\n                " + pattern + ".append(\"" + this.defaultFormat() + "\");\n\n                if (" + d + " > 0) {\n                  " + pattern + ".append(\".\");\n                  for (int " + i + " = 0; " + i + " < " + d + "; " + i + "++) {\n                    " + pattern + ".append(\"0\");\n                  }\n                }\n                " + lastDValue + " = " + d + ";\n                " + numberFormat + ".applyLocalizedPattern(" + pattern + ".toString());\n              }\n              " + ev.value() + " = UTF8String.fromString(" + numberFormat + ".format(" + this.typeHelper$1((String)num) + "));\n            } else {\n              " + ev.value() + " = null;\n              " + ev.isNull() + " = true;\n            }\n           ";
            }
            if (dataType instanceof StringType) {
                String lastDValue = ctx.addMutableState("String", "lastDValue", (Function1<String, String>)(Function1 & Serializable)v -> v + " = null;", ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String dValue = ctx.freshName("dValue");
                return "\n            String " + dValue + " = " + d + ".toString();\n            if (!" + dValue + ".equals(" + lastDValue + ")) {\n              " + lastDValue + " = " + dValue + ";\n              if (" + dValue + ".isEmpty()) {\n                " + numberFormat + ".applyLocalizedPattern(\"" + this.defaultFormat() + "\");\n              } else {\n                " + numberFormat + ".applyLocalizedPattern(" + dValue + ");\n              }\n            }\n            " + ev.value() + " = UTF8String.fromString(" + numberFormat + ".format(" + this.typeHelper$1((String)num) + "));\n           ";
            }
            throw new MatchError((Object)dataType);
        });
    }

    @Override
    public String prettyName() {
        return "format_number";
    }

    @Override
    public FormatNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FormatNumber copy(Expression x, Expression d) {
        return new FormatNumber(x, d);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.d();
    }

    @Override
    public String productPrefix() {
        return "FormatNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.x();
            }
            case 1: {
                return this.d();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatNumber;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "x";
            }
            case 1: {
                return "d";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatNumber formatNumber = (FormatNumber)x$1;
        Expression expression = this.x();
        Expression expression2 = formatNumber.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.d();
        Expression expression4 = formatNumber.d();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!formatNumber.canEqual(this)) return false;
        return true;
    }

    private final String typeHelper$1(String p) {
        DataType dataType = this.x().dataType();
        if (dataType instanceof DecimalType) {
            return p + ".toJavaBigDecimal()";
        }
        return String.valueOf(p);
    }

    public FormatNumber(Expression x, Expression d) {
        this.x = x;
        this.d = d;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        this.defaultFormat = "#,###,###,###,###,###,##0";
        this.lastDIntValue = None$.MODULE$;
        this.lastDStringValue = None$.MODULE$;
    }
}

