/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;

public class NettyLogger {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(NettyLogger.class);
    private final LoggingHandler loggingHandler = logger.isTraceEnabled() ? new LoggingHandler(NettyLogger.class, LogLevel.TRACE) : (logger.isDebugEnabled() ? new NoContentLoggingHandler(NettyLogger.class, LogLevel.DEBUG) : null);

    public LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    private static class NoContentLoggingHandler
    extends LoggingHandler {
        NoContentLoggingHandler(Class<?> clazz, LogLevel level) {
            super(clazz, level);
        }

        protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
            if (arg instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)arg;
                return this.format(ctx, eventName) + " " + byteBuf.readableBytes() + "B";
            }
            if (arg instanceof ByteBufHolder) {
                ByteBufHolder byteBufHolder = (ByteBufHolder)arg;
                return this.format(ctx, eventName) + " " + byteBufHolder.content().readableBytes() + "B";
            }
            if (arg instanceof InputStream) {
                InputStream inputStream = (InputStream)arg;
                int available = -1;
                try {
                    available = inputStream.available();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.format(ctx, eventName, arg) + " " + available + "B";
            }
            return super.format(ctx, eventName, arg);
        }
    }
}

