/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.TimeTravelSpec;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.V2TableUtil$;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2RelationBase$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ec!B\t\u0013\u0003\u0003\t\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003k\u0011\u0015q\u0007\u0001\"\u0001p\u0011!A\b\u0001#b\u0001\n\u0003I\b\"\u0002@\u0001\t\u0003z\bbBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tI\u0003\u0001C!\u0003W9\u0011\"a\r\u0013\u0003\u0003E\t!!\u000e\u0007\u0011E\u0011\u0012\u0011!E\u0001\u0003oAaA\u001c\b\u0005\u0002\u0005}\u0002\"CA!\u001dE\u0005I\u0011AA\"\u0005a!\u0015\r^1T_V\u00148-\u001a,3%\u0016d\u0017\r^5p]\n\u000b7/\u001a\u0006\u0003'Q\t!A\u001e\u001a\u000b\u0005U1\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0006\r\u0002\u0013\u0015DXmY;uS>t'BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011#\u0002\u0001#Y=*\u0004CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u001dawnZ5dC2T!a\n\u0015\u0002\u000bAd\u0017M\\:\u000b\u0005%B\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005-\"#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"aI\u0017\n\u00059\"#\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IB\u0013\u0001C1oC2L8/[:\n\u0005Q\n$!F'vYRL\u0017J\\:uC:\u001cWMU3mCRLwN\u001c\t\u0003aYJ!aN\u0019\u0003\u001b9\u000bW.\u001a3SK2\fG/[8o\u0003\u0015!\u0018M\u00197f!\tQt(D\u0001<\u0015\taT(A\u0004dCR\fGn\\4\u000b\u0005yB\u0012!C2p]:,7\r^8s\u0013\t\u00015HA\u0003UC\ndW-\u0001\u0004pkR\u0004X\u000f\u001e\t\u0004\u00076\u0003fB\u0001#K\u001d\t)\u0005*D\u0001G\u0015\t9\u0005%\u0001\u0004=e>|GOP\u0005\u0002\u0013\u0006)1oY1mC&\u00111\nT\u0001\ba\u0006\u001c7.Y4f\u0015\u0005I\u0015B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003\u00172\u0003\"!\u0015+\u000e\u0003IS!a\u0015\u0015\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003+J\u0013!#\u0011;ue&\u0014W\u000f^3SK\u001a,'/\u001a8dKB\u0019q\u000b\u0017.\u000e\u00031K!!\u0017'\u0003\r=\u0003H/[8o!\tQ4,\u0003\u0002]w\ti1)\u0019;bY><\u0007\u000b\\;hS:\f!\"\u001b3f]RLg-[3s!\r9\u0006l\u0018\t\u0003u\u0001L!!Y\u001e\u0003\u0015%#WM\u001c;jM&,'/A\u0004paRLwN\\:\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019D\u0012\u0001B;uS2L!\u0001[3\u00031\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016\u001cFO]5oO6\u000b\u0007/\u0001\buS6,GK]1wK2\u001c\u0006/Z2\u0011\u0007]C6\u000e\u0005\u00021Y&\u0011Q.\r\u0002\u000f)&lW\r\u0016:bm\u0016d7\u000b]3d\u0003\u0019a\u0014N\\5u}Q9\u0001O]:ukZ<\bCA9\u0001\u001b\u0005\u0011\u0002\"\u0002\u001d\b\u0001\u0004I\u0004\"B!\b\u0001\u0004\u0011\u0005\"\u0002\u001f\b\u0001\u00041\u0006\"B/\b\u0001\u0004q\u0006\"\u00022\b\u0001\u0004\u0019\u0007bB5\b!\u0003\u0005\rA[\u0001\u000bMVt7)\u0019;bY><W#\u0001>\u0011\u0007]C6\u0010\u0005\u0002;y&\u0011Qp\u000f\u0002\u0010\rVt7\r^5p]\u000e\u000bG/\u00197pO\u0006!a.Y7f+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u000f\u0001\"!\u0012'\n\u0007\u0005%A*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013a\u0015\u0001F:lSB\u001c6\r[3nCJ+7o\u001c7vi&|g.\u0006\u0002\u0002\u0016A\u0019q+a\u0006\n\u0007\u0005eAJA\u0004C_>dW-\u00198\u0002\u0019MLW\u000e\u001d7f'R\u0014\u0018N\\4\u0015\t\u0005\u0005\u0011q\u0004\u0005\b\u0003CY\u0001\u0019AA\u0012\u0003%i\u0017\r\u001f$jK2$7\u000fE\u0002X\u0003KI1!a\nM\u0005\rIe\u000e^\u0001\rG>l\u0007/\u001e;f'R\fGo\u001d\u000b\u0003\u0003[\u00012aIA\u0018\u0013\r\t\t\u0004\n\u0002\u000b'R\fG/[:uS\u000e\u001c\u0018\u0001\u0007#bi\u0006\u001cv.\u001e:dKZ\u0013$+\u001a7bi&|gNQ1tKB\u0011\u0011OD\n\u0004\u001d\u0005e\u0002cA,\u0002<%\u0019\u0011Q\b'\u0003\r\u0005s\u0017PU3g)\t\t)$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003\u000bR3A[A$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class DataSourceV2RelationBase
extends LogicalPlan
implements LeafNode,
MultiInstanceRelation,
NamedRelation {
    private Option<FunctionCatalog> funCatalog;
    private final Table table;
    private final Seq<AttributeReference> output;
    private final Option<CatalogPlugin> catalog;
    private final Option<Identifier> identifier;
    private final CaseInsensitiveStringMap options;
    private final Option<TimeTravelSpec> timeTravelSpec;
    private volatile boolean bitmap$0;

    public static Option<TimeTravelSpec> $lessinit$greater$default$6() {
        return DataSourceV2RelationBase$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public AttributeSet producedAttributes() {
        return LeafNode.producedAttributes$(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$(this, f);
    }

    @Override
    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$(this, newChildren);
    }

    private Option<FunctionCatalog> funCatalog$lzycompute() {
        DataSourceV2RelationBase dataSourceV2RelationBase = this;
        synchronized (dataSourceV2RelationBase) {
            if (!this.bitmap$0) {
                this.funCatalog = this.catalog.collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends CatalogPlugin, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof FunctionCatalog) {
                            FunctionCatalog functionCatalog = (FunctionCatalog)A1;
                            return (B1)functionCatalog;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(CatalogPlugin x1) {
                        CatalogPlugin catalogPlugin = x1;
                        return catalogPlugin instanceof FunctionCatalog;
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this.funCatalog;
    }

    public Option<FunctionCatalog> funCatalog() {
        if (!this.bitmap$0) {
            return this.funCatalog$lzycompute();
        }
        return this.funCatalog;
    }

    @Override
    public String name() {
        Tuple2 tuple2 = new Tuple2(this.catalog, this.identifier);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                CatalogPlugin cat = (CatalogPlugin)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Identifier ident = (Identifier)some2.value();
                    return V2TableUtil$.MODULE$.toQualifiedName(cat, ident);
                }
            }
        }
        return this.table.name();
    }

    @Override
    public boolean skipSchemaResolution() {
        return DataSourceV2Implicits$.MODULE$.TableHelper(this.table).supports(TableCapability.ACCEPT_ANY_SCHEMA);
    }

    @Override
    public String simpleString(int maxFields) {
        Object object;
        String outputString = package$.MODULE$.truncatedString(this.output, "[", ", ", "]", maxFields);
        Option<TimeTravelSpec> option = this.timeTravelSpec;
        if (option instanceof Some) {
            Some some = (Some)option;
            TimeTravelSpec spec = (TimeTravelSpec)some.value();
            object = this.name() + " " + spec;
        } else {
            object = this.name();
        }
        String nameWithTimeTravelSpec = object;
        return "RelationV2" + outputString + " " + nameWithTimeTravelSpec;
    }

    @Override
    public org.apache.spark.sql.catalyst.plans.logical.Statistics computeStats() {
        if (Utils$.MODULE$.isTesting()) {
            throw SparkException$.MODULE$.internalError("BUG: computeStats called before pushdown on DSv2 relation: " + this.name());
        }
        Scan scan = DataSourceV2Implicits$.MODULE$.TableHelper(this.table).asReadable().newScanBuilder(this.options).build();
        if (scan instanceof SupportsReportStatistics) {
            SupportsReportStatistics supportsReportStatistics = (SupportsReportStatistics)scan;
            Statistics statistics = supportsReportStatistics.estimateStatistics();
            return DataSourceV2Relation$.MODULE$.transformV2Stats(statistics, (Option<BigInt>)None$.MODULE$, this.conf().defaultSizeInBytes(), this.output);
        }
        return new org.apache.spark.sql.catalyst.plans.logical.Statistics(BigInt$.MODULE$.long2bigInt(this.conf().defaultSizeInBytes()), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
    }

    public DataSourceV2RelationBase(Table table, Seq<AttributeReference> output, Option<CatalogPlugin> catalog, Option<Identifier> identifier, CaseInsensitiveStringMap options, Option<TimeTravelSpec> timeTravelSpec) {
        this.table = table;
        this.output = output;
        this.catalog = catalog;
        this.identifier = identifier;
        this.options = options;
        this.timeTravelSpec = timeTravelSpec;
        LeafLike.$init$(this);
        LeafNode.$init$(this);
        NamedRelation.$init$(this);
    }
}

