/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class VersionUtils$ {
    public static final VersionUtils$ MODULE$ = new VersionUtils$();
    private static final Regex majorMinorRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d+)\\.(\\d+)(\\..*)?$"));
    private static final Regex shortVersionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d+\\.\\d+\\.\\d+)(.*)?$"));
    private static final Regex majorMinorPatchRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:[.-].*)?)?)?$"));

    private Regex majorMinorRegex() {
        return majorMinorRegex;
    }

    private Regex shortVersionRegex() {
        return shortVersionRegex;
    }

    private Regex majorMinorPatchRegex() {
        return majorMinorPatchRegex;
    }

    public int majorVersion(String sparkVersion) {
        return this.majorMinorVersion(sparkVersion)._1$mcI$sp();
    }

    public int minorVersion(String sparkVersion) {
        return this.majorMinorVersion(sparkVersion)._2$mcI$sp();
    }

    public String shortVersion(String sparkVersion) {
        Option option = this.shortVersionRegex().findFirstMatchIn((CharSequence)sparkVersion);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return m.group(1);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Spark tried to parse '" + sparkVersion + "' as a Spark version string, but it could not find the major/minor/maintenance version numbers.");
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<Object, Object> majorMinorVersion(String sparkVersion) {
        Option option = this.majorMinorRegex().findFirstMatchIn((CharSequence)sparkVersion);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple2.mcII.sp(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(2))));
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Spark tried to parse '" + sparkVersion + "' as a Spark version string, but it could not find the major and minor version numbers.");
        }
        throw new MatchError((Object)option);
    }

    public Option<Tuple3<Object, Object, Object>> majorMinorPatchVersion(String version) {
        return this.majorMinorPatchRegex().findFirstMatchIn((CharSequence)version).map((Function1 & Serializable)m -> {
            int major = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1)));
            int minor = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)m.group(2)).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            int patch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)m.group(3)).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)major), (Object)BoxesRunTime.boxToInteger((int)minor), (Object)BoxesRunTime.boxToInteger((int)patch));
        });
    }

    private VersionUtils$() {
    }
}

