/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeographyType$;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.GeometryType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.ArrayImplicits$;
import org.sparkproject.org.apache.arrow.memory.RootAllocator;
import org.sparkproject.org.apache.arrow.vector.types.DateUnit;
import org.sparkproject.org.apache.arrow.vector.types.FloatingPointPrecision;
import org.sparkproject.org.apache.arrow.vector.types.IntervalUnit;
import org.sparkproject.org.apache.arrow.vector.types.TimeUnit;
import org.sparkproject.org.apache.arrow.vector.types.pojo.ArrowType;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;
import org.sparkproject.org.apache.arrow.vector.types.pojo.FieldType;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Schema;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ArrowUtils$ {
    public static final ArrowUtils$ MODULE$ = new ArrowUtils$();
    private static final RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);
    private static final String metadataKey = "SPARK::metadata::json";

    public RootAllocator rootAllocator() {
        return rootAllocator;
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId, boolean largeVarTypes) {
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        boolean bl = false;
        StringType stringType = null;
        boolean bl2 = false;
        DataType dataType = null;
        boolean bl3 = false;
        DataType dataType2 = null;
        DataType dataType3 = dt;
        if (BooleanType$.MODULE$.equals(dataType3)) {
            return ArrowType.Bool.INSTANCE;
        }
        if (ByteType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Int(8, true);
        }
        if (ShortType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Int(16, true);
        }
        if (IntegerType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Int(32, true);
        }
        if (LongType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Int(64, true);
        }
        if (FloatType$.MODULE$.equals(dataType3)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (DoubleType$.MODULE$.equals(dataType3)) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (dataType3 instanceof StringType) {
            bl = true;
            stringType = (StringType)dataType3;
            if (!largeVarTypes) {
                return ArrowType.Utf8.INSTANCE;
            }
        }
        if (BinaryType$.MODULE$.equals(dataType3)) {
            bl2 = true;
            dataType = dataType3;
            if (!largeVarTypes) {
                return ArrowType.Binary.INSTANCE;
            }
        }
        if (bl && largeVarTypes) {
            return ArrowType.LargeUtf8.INSTANCE;
        }
        if (bl2 && largeVarTypes) {
            return ArrowType.LargeBinary.INSTANCE;
        }
        if (dataType3 instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return new ArrowType.Decimal(precision, scale, 128);
        }
        if (DateType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Date(DateUnit.DAY);
        }
        if (TimestampType$.MODULE$.equals(dataType3)) {
            bl3 = true;
            dataType2 = dataType3;
            if (timeZoneId == null) {
                throw SparkException$.MODULE$.internalError("Missing timezoneId where it is mandatory.");
            }
        }
        if (bl3) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        }
        if (TimestampNTZType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
        }
        if (dataType3 instanceof TimeType) {
            return new ArrowType.Time(TimeUnit.NANOSECOND, 64);
        }
        if (NullType$.MODULE$.equals(dataType3)) {
            return ArrowType.Null.INSTANCE;
        }
        if (dataType3 instanceof YearMonthIntervalType) {
            return new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        }
        if (dataType3 instanceof DayTimeIntervalType) {
            return new ArrowType.Duration(TimeUnit.MICROSECOND);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
            return new ArrowType.Interval(IntervalUnit.MONTH_DAY_NANO);
        }
        throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(dt);
    }

    public boolean toArrowType$default$3() {
        return false;
    }

    public DataType fromArrowType(ArrowType dt) {
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        boolean bl3 = false;
        ArrowType.Timestamp timestamp = null;
        boolean bl4 = false;
        ArrowType.Interval interval = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !((Object)bool).equals(arrowType2) : arrowType2 != null)) {
            return BooleanType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                return ByteType$.MODULE$;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            return ShortType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            return IntegerType$.MODULE$;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            return LongType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !((Object)((Object)floatingPointPrecision)).equals((Object)floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                return FloatType$.MODULE$;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !((Object)((Object)floatingPointPrecision)).equals((Object)floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                return DoubleType$.MODULE$;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !((Object)utf8).equals(arrowType3) : arrowType3 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !((Object)binary).equals(arrowType4) : arrowType4 != null)) {
            return BinaryType$.MODULE$;
        }
        ArrowType.LargeUtf8 largeUtf8 = ArrowType.LargeUtf8.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(largeUtf8 != null ? !((Object)largeUtf8).equals(arrowType5) : arrowType5 != null)) {
            return StringType$.MODULE$;
        }
        ArrowType.LargeBinary largeBinary = ArrowType.LargeBinary.INSTANCE;
        ArrowType arrowType6 = arrowType;
        if (!(largeBinary != null ? !((Object)largeBinary).equals(arrowType6) : arrowType6 != null)) {
            return BinaryType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            return new DecimalType(decimal.getPrecision(), decimal.getScale());
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !((Object)((Object)dateUnit)).equals((Object)dateUnit2) : dateUnit2 != null)) {
                return DateType$.MODULE$;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            bl3 = true;
            timestamp = (ArrowType.Timestamp)arrowType;
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit2) : timeUnit2 != null) && timestamp.getTimezone() == null) {
                return TimestampNTZType$.MODULE$;
            }
        }
        if (bl3) {
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit3 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit3) : timeUnit3 != null)) {
                return TimestampType$.MODULE$;
            }
        }
        if (arrowType instanceof ArrowType.Time) {
            ArrowType.Time time = (ArrowType.Time)arrowType;
            TimeUnit timeUnit = time.getUnit();
            TimeUnit timeUnit4 = TimeUnit.NANOSECOND;
            if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit4) : timeUnit4 != null) && time.getBitWidth() == 64) {
                return new TimeType(TimeType$.MODULE$.MICROS_PRECISION());
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType7 = arrowType;
        if (!(nullVal != null ? !((Object)nullVal).equals(arrowType7) : arrowType7 != null)) {
            return NullType$.MODULE$;
        }
        if (arrowType instanceof ArrowType.Interval) {
            bl4 = true;
            interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !((Object)((Object)intervalUnit)).equals((Object)intervalUnit2) : intervalUnit2 != null)) {
                return YearMonthIntervalType$.MODULE$.apply();
            }
        }
        if (arrowType instanceof ArrowType.Duration) {
            ArrowType.Duration duration = (ArrowType.Duration)arrowType;
            TimeUnit timeUnit = duration.getUnit();
            TimeUnit timeUnit5 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !((Object)((Object)timeUnit)).equals((Object)timeUnit5) : timeUnit5 != null)) {
                return DayTimeIntervalType$.MODULE$.apply();
            }
        }
        if (bl4) {
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit3 = IntervalUnit.MONTH_DAY_NANO;
            if (!(intervalUnit != null ? !((Object)((Object)intervalUnit)).equals((Object)intervalUnit3) : intervalUnit3 != null)) {
                return CalendarIntervalType$.MODULE$;
            }
        }
        throw ExecutionErrors$.MODULE$.unsupportedArrowTypeError(dt);
    }

    private String metadataKey() {
        return metadataKey;
    }

    private java.util.Map<String, String> toArrowMetaData(Metadata metadata) {
        if (metadata != null && !metadata.isEmpty()) {
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.metadataKey()), (Object)metadata.json())}))).asJava();
        }
        return null;
    }

    private Metadata fromArrowMetaData(java.util.Map<String, String> map) {
        if (map != null && map.containsKey(this.metadataKey())) {
            return Metadata$.MODULE$.fromJson(map.get(this.metadataKey()));
        }
        return Metadata$.MODULE$.empty();
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId, boolean largeVarTypes, Metadata metadata) {
        DataType dataType;
        while (true) {
            if ((dataType = dt) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                FieldType fieldType = new FieldType(nullable, ArrowType.List.INSTANCE, null, this.toArrowMetaData(metadata));
                return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                FieldType fieldType = new FieldType(nullable, ArrowType.Struct.INSTANCE, null, this.toArrowMetaData(metadata));
                return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId, largeVarTypes, field.metadata()), ClassTag$.MODULE$.apply(Field.class))).toImmutableArraySeq()).asJava());
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                FieldType fieldType = new FieldType(nullable, new ArrowType.Map(false), null, this.toArrowMetaData(metadata));
                return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.toArrowField("entries", new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)Nil$.MODULE$)).asJava());
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)dataType;
            FieldType fieldType = new FieldType(nullable, ArrowType.Struct.INSTANCE, null, this.toArrowMetaData(metadata));
            FieldType wkbFieldType = new FieldType(false, this.toArrowType(BinaryType$.MODULE$, timeZoneId, largeVarTypes), null, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(geometryType.srid()))}))).asJava());
            return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.toArrowField("srid", IntegerType$.MODULE$, false, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)new .colon.colon((Object)new Field("wkb", wkbFieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava()), (List)Nil$.MODULE$))).asJava());
        }
        if (dataType instanceof GeographyType) {
            GeographyType geographyType = (GeographyType)dataType;
            FieldType fieldType = new FieldType(nullable, ArrowType.Struct.INSTANCE, null, this.toArrowMetaData(metadata));
            FieldType wkbFieldType = new FieldType(false, this.toArrowType(BinaryType$.MODULE$, timeZoneId, largeVarTypes), null, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geography"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srid"), (Object)Integer.toString(geographyType.srid()))}))).asJava());
            return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.toArrowField("srid", IntegerType$.MODULE$, false, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)new .colon.colon((Object)new Field("wkb", wkbFieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava()), (List)Nil$.MODULE$))).asJava());
        }
        if (dataType instanceof VariantType) {
            FieldType fieldType = new FieldType(nullable, ArrowType.Struct.INSTANCE, null, this.toArrowMetaData(metadata));
            FieldType metadataFieldType = new FieldType(false, this.toArrowType(BinaryType$.MODULE$, timeZoneId, largeVarTypes), null, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"variant"), (Object)"true")}))).asJava());
            return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.toArrowField("value", BinaryType$.MODULE$, false, timeZoneId, largeVarTypes, this.toArrowField$default$6()), (List)new .colon.colon((Object)new Field("metadata", metadataFieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava()), (List)Nil$.MODULE$))).asJava());
        }
        FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId, largeVarTypes), null, this.toArrowMetaData(metadata));
        return new Field(name, fieldType, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava());
    }

    public boolean toArrowField$default$5() {
        return false;
    }

    public Metadata toArrowField$default$6() {
        return Metadata$.MODULE$.empty();
    }

    public boolean isVariantField(Field field) {
        Predef$.MODULE$.assert(field.getType() instanceof ArrowType.Struct);
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().map((Function1 & Serializable)x$1 -> x$1.getName())).asJava().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"metadata", (List)Nil$.MODULE$))).asJava()) && CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().exists((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)ArrowUtils$.$anonfun$isVariantField$2(child)));
    }

    public boolean isGeometryField(Field field) {
        Predef$.MODULE$.assert(field.getType() instanceof ArrowType.Struct);
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().map((Function1 & Serializable)x$2 -> x$2.getName())).asJava().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"wkb", (List)new .colon.colon((Object)"srid", (List)Nil$.MODULE$))).asJava()) && CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().exists((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)ArrowUtils$.$anonfun$isGeometryField$2(child)));
    }

    public boolean isGeographyField(Field field) {
        Predef$.MODULE$.assert(field.getType() instanceof ArrowType.Struct);
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().map((Function1 & Serializable)x$3 -> x$3.getName())).asJava().containsAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"wkb", (List)new .colon.colon((Object)"srid", (List)Nil$.MODULE$))).asJava()) && CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().exists((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)ArrowUtils$.$anonfun$isGeographyField$2(child)));
    }

    public DataType fromArrowField(Field field) {
        boolean bl = false;
        ArrowType arrowType = null;
        ArrowType arrowType2 = field.getType();
        if (arrowType2 instanceof ArrowType.Map) {
            Field elementField = field.getChildren().get(0);
            DataType keyType = this.fromArrowField(elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField(elementField.getChildren().get(1));
            return new MapType(keyType, valueType, elementField.getChildren().get(1).isNullable());
        }
        ArrowType.List list = ArrowType.List.INSTANCE;
        ArrowType arrowType3 = arrowType2;
        if (!(list != null ? !((Object)list).equals(arrowType3) : arrowType3 != null)) {
            Field elementField = field.getChildren().get(0);
            DataType elementType = this.fromArrowField(elementField);
            return new ArrayType(elementType, elementField.isNullable());
        }
        ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
        ArrowType arrowType4 = arrowType2;
        if (!(struct != null ? !((Object)struct).equals(arrowType4) : arrowType4 != null)) {
            bl = true;
            arrowType = arrowType2;
            if (this.isVariantField(field)) {
                return VariantType$.MODULE$;
            }
        }
        if (bl && this.isGeometryField(field)) {
            Field metadataField = (Field)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)ArrowUtils$.$anonfun$fromArrowField$1(child)))).head();
            int srid = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(metadataField.getMetadata().get("srid")));
            if (srid == GeometryType$.MODULE$.MIXED_SRID()) {
                return GeometryType$.MODULE$.apply("ANY");
            }
            return GeometryType$.MODULE$.apply(srid);
        }
        if (bl && this.isGeographyField(field)) {
            Field metadataField = (Field)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)ArrowUtils$.$anonfun$fromArrowField$2(child)))).head();
            int srid = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(metadataField.getMetadata().get("srid")));
            if (srid == GeographyType$.MODULE$.MIXED_SRID()) {
                return GeographyType$.MODULE$.apply("ANY");
            }
            return GeographyType$.MODULE$.apply(srid);
        }
        if (bl) {
            Buffer fields = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(field.getChildren()).asScala().map((Function1 & Serializable)child -> {
                DataType dt = MODULE$.fromArrowField((Field)child);
                return new StructField(child.getName(), dt, child.isNullable(), MODULE$.fromArrowMetaData(child.getMetadata()));
            });
            return new StructType((StructField[])fields.toArray(ClassTag$.MODULE$.apply(StructField.class)));
        }
        return this.fromArrowType(arrowType2);
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, boolean largeVarTypes) {
        return new Schema(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)schema.map((Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), MODULE$.deduplicateFieldNames(field.dataType(), errorOnDuplicatedFieldNames), field.nullable(), timeZoneId, largeVarTypes, field.metadata()))).asJava());
    }

    public StructType fromArrowSchema(Schema schema) {
        return new StructType((StructField[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(schema.getFields()).asScala().map((Function1 & Serializable)field -> new StructField(field.getName(), MODULE$.fromArrowField((Field)field), field.isNullable(), MODULE$.fromArrowMetaData(field.getMetadata())))).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    private DataType deduplicateFieldNames(DataType dt, boolean errorOnDuplicatedFieldNames) {
        DataType dataType;
        while ((dataType = dt) instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof StructType) {
            String[] stringArray;
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            if (Predef$.MODULE$.wrapRefArray((Object[])structType.names()).toSet().size() == structType.names().length) {
                stringArray = structType.names();
            } else {
                if (errorOnDuplicatedFieldNames) {
                    throw ExecutionErrors$.MODULE$.duplicatedFieldNameInArrowStructError((scala.collection.immutable.Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)structType.names()).toImmutableArraySeq());
                }
                scala.collection.immutable.Map genNawName = (scala.collection.immutable.Map)ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])structType.names()), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String[] names = (String[])tuple2._2();
                        if (names.length > 1) {
                            AtomicInteger i = new AtomicInteger();
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable)() -> name + "_" + i.getAndIncrement());
                        }
                    }
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Function0 & Serializable)() -> name);
                    }
                    throw new MatchError((Object)tuple2);
                });
                stringArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.names()), (Function1 & Serializable)x$4 -> (String)((Function0)genNawName.apply(x$4)).apply(), ClassTag$.MODULE$.apply(String.class));
            }
            String[] newNames = stringArray;
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])newNames))), (Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField structField = (StructField)tuple2._1();
                    String name = (String)tuple2._2();
                    if (structField != null) {
                        DataType dataType = structField.dataType();
                        boolean nullable = structField.nullable();
                        Metadata metadata = structField.metadata();
                        return new StructField(name, MODULE$.deduplicateFieldNames(dataType, errorOnDuplicatedFieldNames), nullable, metadata);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(StructField.class));
            return new StructType(newFields);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return new ArrayType(this.deduplicateFieldNames(elementType, errorOnDuplicatedFieldNames), containsNull);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return new MapType(this.deduplicateFieldNames(keyType, errorOnDuplicatedFieldNames), this.deduplicateFieldNames(valueType, errorOnDuplicatedFieldNames), valueContainsNull);
        }
        return dt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isVariantField$2(Field child) {
        String string = child.getName();
        String string2 = "metadata";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = child.getMetadata().getOrDefault("variant", "false");
        String string4 = "true";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isGeometryField$2(Field child) {
        String string = child.getName();
        String string2 = "wkb";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = child.getMetadata().getOrDefault("geometry", "false");
        String string4 = "true";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isGeographyField$2(Field child) {
        String string = child.getName();
        String string2 = "wkb";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = child.getMetadata().getOrDefault("geography", "false");
        String string4 = "true";
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fromArrowField$1(Field child) {
        String string = child.getName();
        String string2 = "wkb";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fromArrowField$2(Field child) {
        String string = child.getName();
        String string2 = "wkb";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ArrowUtils$() {
    }
}

