/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.handler;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.HttpMethod;
import org.sparkproject.jetty.http.HttpStatus;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.server.ConnectionMetaData;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.HttpConfiguration;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.handler.ConditionalHandler;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.IncludeExclude;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.thread.Invocable;

public class BufferedResponseHandler
extends ConditionalHandler.Abstract {
    public static final String BUFFER_SIZE_ATTRIBUTE_NAME = BufferedResponseHandler.class.getName() + ".buffer-size";
    public static final String MAX_AGGREGATION_SIZE_ATTRIBUTE_NAME = BufferedResponseHandler.class.getName() + ".max-aggregation-size";
    private static final Logger LOG = LoggerFactory.getLogger(BufferedResponseHandler.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();

    public BufferedResponseHandler() {
        this((Handler)null);
    }

    public BufferedResponseHandler(Handler handler) {
        super(handler);
        this.includeMethod(HttpMethod.GET.asString());
        for (String type : MimeTypes.DEFAULTS.getMimeMap().values()) {
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude(type);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} mime types {}", (Object)this, this._mimeTypes);
        }
    }

    public void includeMimeType(String ... mimeTypes) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._mimeTypes.include((T[])mimeTypes);
    }

    public void excludeMimeType(String ... mimeTypes) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._mimeTypes.exclude((T[])mimeTypes);
    }

    protected boolean isMimeTypeBufferable(String mimetype) {
        return this._mimeTypes.test(mimetype);
    }

    protected boolean shouldBuffer(Response response, boolean last) {
        if (last) {
            return false;
        }
        int status = response.getStatus();
        if (HttpStatus.hasNoBody(status) || HttpStatus.isRedirectionWithLocation(status)) {
            return false;
        }
        String ct = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (ct == null) {
            return true;
        }
        ct = MimeTypes.getContentTypeWithoutCharset(ct);
        return this.isMimeTypeBufferable(StringUtil.asciiToLowerCase(ct));
    }

    @Override
    public boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
        String mimeType;
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} doHandle {} in {}", new Object[]{this, request, request.getContext()});
        }
        if ((mimeType = request.getContext().getMimeTypes().getMimeByExtension(request.getHttpURI().getCanonicalPath())) != null && !this.isMimeTypeBufferable(mimeType = MimeTypes.getContentTypeWithoutCharset(mimeType))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by path suffix mime type {}", (Object)this, (Object)request);
            }
            return next.handle(request, response, callback);
        }
        BufferedResponse bufferedResponse = new BufferedResponse(request, response, callback);
        return next.handle(request, bufferedResponse, bufferedResponse);
    }

    @Override
    protected boolean onConditionsNotMet(Request request, Response response, Callback callback) throws Exception {
        return this.nextHandler(request, response, callback);
    }

    private class BufferedResponse
    extends Response.Wrapper
    implements Callback {
        private final Callback _callback;
        private Content.Sink _bufferedContentSink;
        private boolean _firstWrite;
        private boolean _lastWritten;

        private BufferedResponse(Request request, Response response, Callback callback) {
            super(request, response);
            this._firstWrite = true;
            this._callback = callback;
        }

        @Override
        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            if (this._firstWrite) {
                this._firstWrite = false;
                if (BufferedResponseHandler.this.shouldBuffer(this, last)) {
                    this._bufferedContentSink = this.createBufferedSink();
                }
            }
            this._lastWritten |= last;
            Content.Sink destSink = this._bufferedContentSink != null ? this._bufferedContentSink : this.getWrapped();
            destSink.write(last, byteBuffer, callback);
        }

        private Content.Sink createBufferedSink() {
            Request request = this.getRequest();
            ConnectionMetaData connectionMetaData = request.getConnectionMetaData();
            ByteBufferPool bufferPool = connectionMetaData.getConnector().getByteBufferPool();
            HttpConfiguration httpConfiguration = connectionMetaData.getHttpConfiguration();
            Object attribute = request.getAttribute(BUFFER_SIZE_ATTRIBUTE_NAME);
            int bufferSize = attribute instanceof Integer ? ((Integer)attribute).intValue() : httpConfiguration.getOutputBufferSize();
            attribute = request.getAttribute(MAX_AGGREGATION_SIZE_ATTRIBUTE_NAME);
            int maxAggregationSize = attribute instanceof Integer ? ((Integer)attribute).intValue() : httpConfiguration.getOutputAggregationSize();
            boolean direct = httpConfiguration.isUseOutputDirectByteBuffers();
            return Content.Sink.asBuffered(this.getWrapped(), bufferPool, direct, maxAggregationSize, bufferSize);
        }

        @Override
        public void succeeded() {
            if (this._bufferedContentSink != null && !this._lastWritten) {
                this._bufferedContentSink.write(true, null, this._callback);
            } else {
                this._callback.succeeded();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this._bufferedContentSink != null && !this._lastWritten) {
                this._bufferedContentSink.write(true, null, Callback.from(this._callback, x));
            } else {
                this._callback.failed(x);
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }
    }
}

