/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryBoundsException;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummaryDeserializer;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$AlwaysOne$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Max$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Min$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.math.Numeric;

public final class TupleSketchUtils$ {
    public static final TupleSketchUtils$ MODULE$ = new TupleSketchUtils$();

    public <U extends Summary> Sketch<U> heapifySketch(byte[] bytes, SummaryDeserializer<U> deserializer, String prettyName) {
        Sketch sketch;
        Memory memory;
        try {
            memory = Memory.wrap((byte[])bytes);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NullPointerException ? true : throwable2 instanceof MemoryBoundsException) {
                throw QueryExecutionErrors$.MODULE$.thetaInvalidInputSketchBuffer(prettyName);
            }
            throw throwable;
        }
        Memory memory2 = memory;
        try {
            sketch = Sketches.heapifySketch((Memory)memory2, deserializer);
        }
        catch (Exception exception) {
            throw QueryExecutionErrors$.MODULE$.tupleInvalidInputSketchBuffer(prettyName);
        }
        return sketch;
    }

    public Sketch<DoubleSummary> heapifyDoubleSketch(byte[] bytes, String prettyName) {
        return this.heapifySketch(bytes, (SummaryDeserializer)new DoubleSummaryDeserializer(), prettyName);
    }

    public Sketch<IntegerSummary> heapifyIntegerSketch(byte[] bytes, String prettyName) {
        return this.heapifySketch(bytes, (SummaryDeserializer)new IntegerSummaryDeserializer(), prettyName);
    }

    public <S extends Summary, V> V aggregateNumericSummaries(TupleSketchIterator<S> iterator, TupleSummaryMode mode, Function1<TupleSketchIterator<S>, V> getValue, Numeric<V> num) {
        TupleSummaryMode tupleSummaryMode = mode;
        if (TupleSummaryMode$Sum$.MODULE$.equals(tupleSummaryMode)) {
            Object sum = num.zero();
            while (iterator.next()) {
                sum = num.plus(sum, getValue.apply(iterator));
            }
            return (V)sum;
        }
        if (TupleSummaryMode$Min$.MODULE$.equals(tupleSummaryMode)) {
            None$ min = None$.MODULE$;
            while (iterator.next()) {
                Some some;
                Object value = getValue.apply(iterator);
                None$ none$ = min;
                if (none$ instanceof Some) {
                    Some some2 = (Some)none$;
                    Object m = some2.value();
                    some = new Some(num.min(m, value));
                } else if (None$.MODULE$.equals(none$)) {
                    some = new Some(value);
                } else {
                    throw new MatchError((Object)none$);
                }
                min = some;
            }
            return (V)min.getOrElse((Function0 & Serializable)() -> num.zero());
        }
        if (TupleSummaryMode$Max$.MODULE$.equals(tupleSummaryMode)) {
            None$ max = None$.MODULE$;
            while (iterator.next()) {
                Some some;
                Object value = getValue.apply(iterator);
                None$ none$ = max;
                if (none$ instanceof Some) {
                    Some some3 = (Some)none$;
                    Object m = some3.value();
                    some = new Some(num.max(m, value));
                } else if (None$.MODULE$.equals(none$)) {
                    some = new Some(value);
                } else {
                    throw new MatchError((Object)none$);
                }
                max = some;
            }
            return (V)max.getOrElse((Function0 & Serializable)() -> num.zero());
        }
        if (TupleSummaryMode$AlwaysOne$.MODULE$.equals(tupleSummaryMode)) {
            Object count = num.zero();
            while (iterator.next()) {
                count = num.plus(count, num.one());
            }
            return (V)count;
        }
        throw new MatchError((Object)tupleSummaryMode);
    }

    private TupleSketchUtils$() {
    }
}

