/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.streaming.SupportsRealTimeRead;
import org.apache.spark.sql.execution.streaming.runtime.ContinuousRecordPartitionOffset;
import org.apache.spark.sql.execution.streaming.runtime.GetRecord;
import org.apache.spark.util.Clock;
import org.apache.spark.util.RpcUtils$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\f\u0018\u0001\u0011B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003S\u0011!9\u0006A!A!\u0002\u0013\u0011\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u000b}\u0003A\u0011\u00011\t\u000f%\u0004!\u0019!C\u0005U\"1a\u000e\u0001Q\u0001\n-Dqa\u001c\u0001A\u0002\u0013%\u0001\u000fC\u0004r\u0001\u0001\u0007I\u0011\u0002:\t\ra\u0004\u0001\u0015)\u0003S\u0011\u001dI\b\u00011A\u0005\niD\u0011\"!\u0003\u0001\u0001\u0004%I!a\u0003\t\u000f\u0005=\u0001\u0001)Q\u0005w\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!!\u0017\u0001\t\u0003\nY\u0006\u0003\u0004\u0002j\u0001!IA\u001f\u0002&\u0019><H*\u0019;f]\u000eLX*Z7pef\u001cFO]3b[B\u000b'\u000f^5uS>t'+Z1eKJT!\u0001G\r\u0002\u0013M$(/Z1nS:<'B\u0001\u000e\u001c\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001K5\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\t1\fgn\u001a\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0004PE*,7\r\u001e\t\u0004]Q2T\"A\u0018\u000b\u0005a\u0001$BA\u00193\u0003\u0011\u0011X-\u00193\u000b\u0005MZ\u0012!C2p]:,7\r^8s\u0013\t)tF\u0001\u000bTkB\u0004xN\u001d;t%\u0016\fG\u000eV5nKJ+\u0017\r\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003sm\t\u0001bY1uC2L8\u000f^\u0005\u0003wa\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006\u0011BM]5wKJ,e\u000e\u001a9pS:$h*Y7f!\tqtI\u0004\u0002@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iI\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u000e\u000bQ\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tG/\u00113ee\u0016\u001c8\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O;\u0005\u0019!\u000f]2\n\u0005Ak%A\u0003*qG\u0006#GM]3tg\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0003'Rk\u0011aQ\u0005\u0003+\u000e\u00131!\u00138u\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0002\u0013\u0015tGm\u00144gg\u0016$\u0018!B2m_\u000e\\\u0007C\u0001.^\u001b\u0005Y&B\u0001/\u001e\u0003\u0011)H/\u001b7\n\u0005y[&!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\bF\u0004bG\u0012,gm\u001a5\u0011\u0005\t\u0004Q\"A\f\t\u000bq:\u0001\u0019A\u001f\t\u000b);\u0001\u0019A&\t\u000bE;\u0001\u0019\u0001*\t\u000bY;\u0001\u0019\u0001*\t\u000b];\u0001\u0019\u0001*\t\u000ba;\u0001\u0019A-\u0002\u0011\u0015tG\r]8j]R,\u0012a\u001b\t\u0003\u00192L!!\\'\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006IQM\u001c3q_&tG\u000fI\u0001\u000eGV\u0014(/\u001a8u\u001f\u001a47/\u001a;\u0016\u0003I\u000b\u0011cY;se\u0016tGo\u00144gg\u0016$x\fJ3r)\t\u0019h\u000f\u0005\u0002Ti&\u0011Qo\u0011\u0002\u0005+:LG\u000fC\u0004x\u0017\u0005\u0005\t\u0019\u0001*\u0002\u0007a$\u0013'\u0001\bdkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0011\u0002\u000f\r,(O]3oiV\t1\u0010E\u0002TyzL!!`\"\u0003\r=\u0003H/[8o!\u0015\u0019vPNA\u0002\u0013\r\t\ta\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007M\u000b)!C\u0002\u0002\b\r\u0013A\u0001T8oO\u0006Y1-\u001e:sK:$x\fJ3r)\r\u0019\u0018Q\u0002\u0005\bo:\t\t\u00111\u0001|\u0003!\u0019WO\u001d:f]R\u0004\u0013a\u00048fqR<\u0016\u000e\u001e5US6,w.\u001e;\u0015\t\u0005U\u0011q\b\t\u0005\u0003/\tID\u0004\u0003\u0002\u001a\u0005Ub\u0002BA\u000e\u0003gqA!!\b\u000229!\u0011qDA\u0018\u001d\u0011\t\t#!\f\u000f\t\u0005\r\u00121\u0006\b\u0005\u0003K\tICD\u0002A\u0003OI\u0011AI\u0005\u0003A\u0005J!AH\u0010\n\u0005qi\u0012BA\u001a\u001c\u0013\t\t$'\u0003\u0002\u0019a%\u0019\u0011qG\u0018\u0002)M+\b\u000f]8siN\u0014V-\u00197US6,'+Z1e\u0013\u0011\tY$!\u0010\u0003\u0019I+7m\u001c:e'R\fG/^:\u000b\u0007\u0005]r\u0006C\u0004\u0002BA\u0001\r!a\u0011\u0002\u000fQLW.Z8viB\u0019a%!\u0012\n\u0007\u0005\u001dq%\u0001\u0003oKb$HCAA&!\r\u0019\u0016QJ\u0005\u0004\u0003\u001f\u001a%a\u0002\"p_2,\u0017M\\\u0001\u0004O\u0016$H#\u0001\u001c\u0002\u000b\rdwn]3\u0015\u0003M\f\u0011bZ3u\u001f\u001a47/\u001a;\u0015\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rt#A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0014\u0011\r\u0002 \u0007>tG/\u001b8v_V\u001c(+Z2pe\u0012\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$\u0018AF4fiJ+7m\u001c:e/&$\b\u000eV5nKN$\u0018-\u001c9")
public class LowLatencyMemoryStreamPartitionReader
implements SupportsRealTimeRead<InternalRow> {
    private final int partition;
    private final int endOffset;
    private final Clock clock;
    private final RpcEndpointRef endpoint;
    private int currentOffset;
    private Option<Tuple2<InternalRow, Object>> current;

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private int currentOffset() {
        return this.currentOffset;
    }

    private void currentOffset_$eq(int x$1) {
        this.currentOffset = x$1;
    }

    private Option<Tuple2<InternalRow, Object>> current() {
        return this.current;
    }

    private void current_$eq(Option<Tuple2<InternalRow, Object>> x$1) {
        this.current = x$1;
    }

    public SupportsRealTimeRead.RecordStatus nextWithTimeout(Long timeout) {
        long startReadTime = this.clock.nanoTime();
        long elapsedTimeMs = 0L;
        this.current_$eq(this.getRecordWithTimestamp());
        while (this.current().isEmpty()) {
            long POLL_TIME = 10L;
            if (elapsedTimeMs >= Predef$.MODULE$.Long2long(timeout)) {
                return SupportsRealTimeRead.RecordStatus.newStatusWithoutArrivalTime((boolean)false);
            }
            Thread.sleep(POLL_TIME);
            this.current_$eq(this.getRecordWithTimestamp());
            elapsedTimeMs = (this.clock.nanoTime() - startReadTime) / 1000L / 1000L;
        }
        this.currentOffset_$eq(this.currentOffset() + 1);
        return SupportsRealTimeRead.RecordStatus.newStatusWithArrivalTimeMs((Long)Predef$.MODULE$.long2Long(((Tuple2)this.current().get())._2$mcJ$sp()));
    }

    public boolean next() {
        this.current_$eq(this.getRecordWithTimestamp());
        if (this.current().isDefined()) {
            this.currentOffset_$eq(this.currentOffset() + 1);
            return true;
        }
        return false;
    }

    public InternalRow get() {
        return (InternalRow)((Tuple2)this.current().get())._1();
    }

    public void close() {
    }

    public ContinuousRecordPartitionOffset getOffset() {
        return new ContinuousRecordPartitionOffset(this.partition, this.currentOffset());
    }

    private Option<Tuple2<InternalRow, Object>> getRecordWithTimestamp() {
        if (this.currentOffset() >= this.endOffset) {
            return None$.MODULE$;
        }
        return (Option)this.endpoint().askSync((Object)new GetRecord(new ContinuousRecordPartitionOffset(this.partition, this.currentOffset())), ClassTag$.MODULE$.apply(Option.class));
    }

    public LowLatencyMemoryStreamPartitionReader(String driverEndpointName, RpcAddress driverEndpointAddress, int partition, int startOffset, int endOffset, Clock clock) {
        this.partition = partition;
        this.endOffset = endOffset;
        this.clock = clock;
        this.endpoint = RpcUtils$.MODULE$.makeDriverRef(driverEndpointName, driverEndpointAddress.host(), driverEndpointAddress.port(), SparkEnv$.MODULE$.get().rpcEnv());
        this.currentOffset = startOffset;
        this.current = None$.MODULE$;
        if (TaskContext$.MODULE$.get() == null) {
            throw new IllegalStateException("Task context was not set!");
        }
    }
}

