/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.RecordType$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Q3Aa\u0002\u0005\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011!a\u0003A!A!\u0002\u0013i\u0003\"B\u001a\u0001\t\u0003!\u0004\"B\u001d\u0001\t\u0003R\u0004\"B!\u0001\t\u0003\u0012%aG*uCR,7\u000b^8sK\u000eC\u0017M\\4fY><'+Z1eKJ4\u0016G\u0003\u0002\n\u0015\u0005)1\u000f^1uK*\u00111\u0002D\u0001\ngR\u0014X-Y7j]\u001eT!!\u0004\b\u0002\u0013\u0015DXmY;uS>t'BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\t\u0013\tY\u0002BA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014\u0018A\u00014n!\tq\u0012%D\u0001 \u0015\t\u0001#\"A\u0007dQ\u0016\u001c7\u000e]8j]RLgnZ\u0005\u0003E}\u0011Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0006gS2,Gk\u001c*fC\u0012\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u0005\u0019\u001c(BA\u0015\u0013\u0003\u0019A\u0017\rZ8pa&\u00111F\n\u0002\u0005!\u0006$\b.\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011a&M\u0007\u0002_)\u0011\u0001\u0007E\u0001\u0003S>L!AM\u0018\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017A\u0002\u001fj]&$h\b\u0006\u00036m]B\u0004CA\r\u0001\u0011\u0015aB\u00011\u0001\u001e\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015aC\u00011\u0001.\u0003\u001d1XM]:j_:,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0006'\"|'\u000f^\u0001\bO\u0016$h*\u001a=u)\u0005\u0019\u0005#\u0002\u001fE\r:s\u0015BA#>\u0005\u0019!V\u000f\u001d7fgA\u0011qI\u0013\b\u00033!K!!\u0013\u0005\u0002\u0015I+7m\u001c:e)f\u0004X-\u0003\u0002L\u0019\n)a+\u00197vK&\u0011Q*\u0010\u0002\f\u000b:,X.\u001a:bi&|g\u000eE\u0002=\u001fFK!\u0001U\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005q\u0012\u0016BA*>\u0005\u0011\u0011\u0015\u0010^3")
public class StateStoreChangelogReaderV1
extends StateStoreChangelogReader {
    private final Path fileToRead;

    @Override
    public short version() {
        return 1;
    }

    @Override
    public Tuple3<Enumeration.Value, byte[], byte[]> getNext() {
        int keySize = this.input().readInt();
        if (keySize == -1) {
            this.finished_$eq(true);
            return null;
        }
        if (keySize < 0) {
            throw new IOException("Error reading streaming state file " + this.fileToRead + ": key size cannot be " + keySize);
        }
        byte[] keyBuffer = new byte[keySize];
        Utils$.MODULE$.readFully((InputStream)this.input(), keyBuffer, 0, keySize);
        int valueSize = this.input().readInt();
        if (valueSize < 0) {
            return new Tuple3((Object)RecordType$.MODULE$.DELETE_RECORD(), (Object)keyBuffer, null);
        }
        byte[] valueBuffer = new byte[valueSize];
        Utils$.MODULE$.readFully((InputStream)this.input(), valueBuffer, 0, valueSize);
        return new Tuple3((Object)RecordType$.MODULE$.PUT_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
    }

    public StateStoreChangelogReaderV1(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        this.fileToRead = fileToRead;
        super(fm, fileToRead, compressionCodec);
    }
}

