/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.mybatis.pager;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.util.WebUtils;

public final class MybatisPager {
    public static <T> Page<T> getPage(RestRequest request) {
        boolean invalid;
        boolean bl = invalid = request.getSortField().trim().split("\\s+").length > 1;
        if (invalid) {
            throw new IllegalArgumentException(String.format("Invalid argument sortField: %s", request.getSortField()));
        }
        if (request.getSortOrder() == null) {
            request.setSortOrder("desc");
        }
        Page page = new Page();
        page.setCurrent((long)request.getPageNum());
        page.setSize((long)request.getPageSize());
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>(2);
        String sortField = WebUtils.camelToUnderscore(request.getSortField());
        if (StringUtils.equalsIgnoreCase((CharSequence)request.getSortOrder(), (CharSequence)"desc")) {
            orderItems.add(OrderItem.desc((String)sortField));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getSortOrder(), (CharSequence)"asc")) {
            orderItems.add(OrderItem.asc((String)sortField));
        } else {
            throw new IllegalArgumentException("Invalid argument sortOrder: " + request.getSortOrder());
        }
        page.setOrders(orderItems);
        return page;
    }
}

