/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.task.FlinkK8sChangeEventListener;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatcher;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatcherFactory;
import org.apache.streampark.flink.kubernetes.FlinkTrackConfig;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import scala.Enumeration;

@Configuration
public class FlinkK8sWatcherWrapper {
    @Lazy
    @Autowired
    private FlinkK8sChangeEventListener flinkK8sChangeEventListener;
    @Lazy
    @Autowired
    private ApplicationService applicationService;
    @Lazy
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Lazy
    @Autowired
    private FlinkEnvService flinkEnvService;

    @Bean(destroyMethod="close")
    public FlinkK8sWatcher registerFlinkK8sWatcher() {
        FlinkK8sWatcher flinkK8sWatcher = FlinkK8sWatcherFactory.createInstance((FlinkTrackConfig)FlinkTrackConfig.fromConfigHub(), (boolean)true);
        this.initFlinkK8sWatcher(flinkK8sWatcher);
        return flinkK8sWatcher;
    }

    private void initFlinkK8sWatcher(@Nonnull FlinkK8sWatcher trackMonitor) {
        trackMonitor.registerListener((Object)this.flinkK8sChangeEventListener);
        List<TrackId> k8sApp = this.getK8sWatchingApps();
        k8sApp.forEach(arg_0 -> ((FlinkK8sWatcher)trackMonitor).doWatching(arg_0));
    }

    private List<TrackId> getK8sWatchingApps() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(Application::getTracking, (Object)1)).in(Application::getExecutionMode, (Collection)ExecutionMode.getKubernetesMode());
        List k8sApplication = this.applicationService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)k8sApplication)) {
            return Lists.newArrayList();
        }
        return k8sApplication.stream().filter(app -> !FlinkJobState.isEndState((Enumeration.Value)FlinkAppState.Bridge.toK8sFlinkJobState(app.getFlinkAppStateEnum()))).map(this::toTrackId).collect(Collectors.toList());
    }

    public TrackId toTrackId(Application app) {
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(app.getVersionId());
        Properties properties = this.flinkEnvService.getFlinkConfig(flinkEnv, app);
        HashMap dynamicProperties = PropertiesUtils.extractDynamicPropertiesAsJava((String)app.getDynamicProperties());
        String archiveDir = (String)dynamicProperties.get(JobManagerOptions.ARCHIVE_DIR.key());
        if (archiveDir != null) {
            properties.put(JobManagerOptions.ARCHIVE_DIR.key(), archiveDir);
        }
        if (app.getExecutionModeEnum() == ExecutionMode.KUBERNETES_NATIVE_APPLICATION) {
            return TrackId.onApplication((String)app.getK8sNamespace(), (String)app.getJobName(), (long)app.getId(), (String)app.getJobId(), (String)app.getTeamId().toString(), (Properties)properties);
        }
        if (app.getExecutionModeEnum() == ExecutionMode.KUBERNETES_NATIVE_SESSION) {
            FlinkCluster flinkCluster = (FlinkCluster)this.flinkClusterService.getById(app.getFlinkClusterId());
            String namespace = flinkCluster.getK8sNamespace();
            String clusterId = flinkCluster.getClusterId();
            return TrackId.onSession((String)namespace, (String)clusterId, (long)app.getId(), (String)app.getJobId(), (String)app.getTeamId().toString(), (Properties)properties);
        }
        throw new IllegalArgumentException("Illegal K8sExecuteMode, mode=" + app.getExecutionMode());
    }
}

