/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.AbstractContainerOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5ConfOverlay
extends AbstractContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(Krb5ConfOverlay.class);
    static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    static final Path TARGET_PATH = new Path("krb5.conf");
    final Path krb5Conf;

    public Krb5ConfOverlay(@Nullable File krb5Conf) {
        this.krb5Conf = krb5Conf != null ? new Path(krb5Conf.toURI()) : null;
    }

    public Krb5ConfOverlay(@Nullable Path krb5Conf) {
        this.krb5Conf = krb5Conf;
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        if (this.krb5Conf != null) {
            container.getArtifacts().add(ContainerSpecification.Artifact.newBuilder().setSource(this.krb5Conf).setDest(TARGET_PATH).setCachable(true).build());
            container.getSystemProperties().setString(JAVA_SECURITY_KRB5_CONF, TARGET_PATH.getPath());
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        File krb5ConfPath;

        public Builder fromEnvironmentOrConfiguration(Configuration globalConfiguration) {
            String krb5Config;
            String string = krb5Config = System.getProperty(Krb5ConfOverlay.JAVA_SECURITY_KRB5_CONF) != null ? System.getProperty(Krb5ConfOverlay.JAVA_SECURITY_KRB5_CONF) : (String)globalConfiguration.get(SecurityOptions.KERBEROS_KRB5_PATH);
            if (krb5Config != null && krb5Config.length() != 0) {
                this.krb5ConfPath = new File(krb5Config);
                if (!this.krb5ConfPath.exists()) {
                    throw new IllegalStateException("java.security.krb5.conf refers to a non-existent file");
                }
            }
            return this;
        }

        public Krb5ConfOverlay build() {
            return new Krb5ConfOverlay(this.krb5ConfPath);
        }
    }
}

