/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rpc.FencedMainThreadExecutable;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcServer;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;

public abstract class FencedRpcEndpoint<F extends Serializable>
extends RpcEndpoint {
    private final UnfencedMainThreadExecutor unfencedMainThreadExecutor;
    private volatile F fencingToken;
    private volatile RpcEndpoint.MainThreadExecutor fencedMainThreadExecutor;

    protected FencedRpcEndpoint(RpcService rpcService, String endpointId, @Nullable F fencingToken) {
        super(rpcService, endpointId);
        Preconditions.checkArgument((boolean)(this.rpcServer instanceof FencedMainThreadExecutable), (String)"The rpcServer must be of type %s.", (Object[])new Object[]{FencedMainThreadExecutable.class.getSimpleName()});
        this.fencingToken = fencingToken;
        this.unfencedMainThreadExecutor = new UnfencedMainThreadExecutor((FencedMainThreadExecutable)((Object)this.rpcServer));
        this.fencedMainThreadExecutor = new RpcEndpoint.MainThreadExecutor(this.getRpcService().fenceRpcServer(this.rpcServer, fencingToken), this::validateRunsInMainThread);
    }

    protected FencedRpcEndpoint(RpcService rpcService, @Nullable F fencingToken) {
        this(rpcService, UUID.randomUUID().toString(), fencingToken);
    }

    public F getFencingToken() {
        return this.fencingToken;
    }

    protected void setFencingToken(@Nullable F newFencingToken) {
        this.validateRunsInMainThread();
        this.fencingToken = newFencingToken;
        RpcServer mainThreadExecutable = this.getRpcService().fenceRpcServer(this.rpcServer, newFencingToken);
        this.fencedMainThreadExecutor = new RpcEndpoint.MainThreadExecutor(mainThreadExecutable, this::validateRunsInMainThread);
    }

    @Override
    protected RpcEndpoint.MainThreadExecutor getMainThreadExecutor() {
        return this.fencedMainThreadExecutor;
    }

    protected Executor getUnfencedMainThreadExecutor() {
        return this.unfencedMainThreadExecutor;
    }

    protected void runAsyncWithoutFencing(Runnable runnable) {
        if (!(this.rpcServer instanceof FencedMainThreadExecutable)) {
            throw new RuntimeException("FencedRpcEndpoint has not been started with a FencedMainThreadExecutable RpcServer.");
        }
        ((FencedMainThreadExecutable)((Object)this.rpcServer)).runAsyncWithoutFencing(runnable);
    }

    protected <V> CompletableFuture<V> callAsyncWithoutFencing(Callable<V> callable, Time timeout) {
        if (this.rpcServer instanceof FencedMainThreadExecutable) {
            return ((FencedMainThreadExecutable)((Object)this.rpcServer)).callAsyncWithoutFencing(callable, timeout);
        }
        throw new RuntimeException("FencedRpcEndpoint has not been started with a FencedMainThreadExecutable RpcServer.");
    }

    private static class UnfencedMainThreadExecutor
    implements Executor {
        private final FencedMainThreadExecutable gateway;

        UnfencedMainThreadExecutor(FencedMainThreadExecutable gateway) {
            this.gateway = (FencedMainThreadExecutable)Preconditions.checkNotNull((Object)gateway);
        }

        @Override
        public void execute(@Nonnull Runnable runnable) {
            this.gateway.runAsyncWithoutFencing(runnable);
        }
    }
}

