/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.util.Preconditions;

@Public
public class LocalEnvironment
extends ExecutionEnvironment {
    public LocalEnvironment() {
        this(new Configuration());
    }

    public LocalEnvironment(Configuration config) {
        super(LocalEnvironment.validateAndGetConfiguration(config));
    }

    private static Configuration validateAndGetConfiguration(Configuration configuration) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The LocalEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        Configuration effectiveConfiguration = new Configuration((Configuration)Preconditions.checkNotNull((Object)configuration));
        effectiveConfiguration.set(DeploymentOptions.TARGET, (Object)"local");
        effectiveConfiguration.set(DeploymentOptions.ATTACHED, (Object)true);
        return effectiveConfiguration;
    }

    public String toString() {
        return "Local Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ").";
    }
}

