/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.flink.kubernetes.K8sPodTemplateFiles;
import org.apache.streampark.flink.kubernetes.PodTemplateType;
import org.apache.streampark.flink.kubernetes.model.K8sPodTemplates;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PodTemplateTool$ {
    public static PodTemplateTool$ MODULE$;
    private final PodTemplateType KUBERNETES_POD_TEMPLATE;
    private final PodTemplateType KUBERNETES_JM_POD_TEMPLATE;
    private final PodTemplateType KUBERNETES_TM_POD_TEMPLATE;

    static {
        new PodTemplateTool$();
    }

    public PodTemplateType KUBERNETES_POD_TEMPLATE() {
        return this.KUBERNETES_POD_TEMPLATE;
    }

    public PodTemplateType KUBERNETES_JM_POD_TEMPLATE() {
        return this.KUBERNETES_JM_POD_TEMPLATE;
    }

    public PodTemplateType KUBERNETES_TM_POD_TEMPLATE() {
        return this.KUBERNETES_TM_POD_TEMPLATE;
    }

    public K8sPodTemplateFiles preparePodTemplateFiles(String buildWorkspace, K8sPodTemplates podTemplates) {
        File workspaceDir = new File(buildWorkspace);
        Object object = !workspaceDir.exists() ? BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir()) : BoxedUnit.UNIT;
        Map podTempleMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Function2 & java.io.Serializable & Serializable outputTmplContent = (Function2 & java.io.Serializable & Serializable)(tmplContent, podTmpl) -> {
            BoxedUnit boxedUnit;
            if (new StringOps(Predef$.MODULE$.augmentString(tmplContent)).nonEmpty()) {
                String outputPath = new StringBuilder(1).append(buildWorkspace).append("/").append(podTmpl.fileName()).toString();
                File outputFile = new File(outputPath);
                FileUtils.write((File)outputFile, (CharSequence)tmplContent, (String)"UTF-8");
                boxedUnit = podTempleMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)podTmpl.key()), (Object)outputPath));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        };
        outputTmplContent.apply((Object)podTemplates.podTemplate(), (Object)this.KUBERNETES_POD_TEMPLATE());
        outputTmplContent.apply((Object)podTemplates.jmPodTemplate(), (Object)this.KUBERNETES_JM_POD_TEMPLATE());
        outputTmplContent.apply((Object)podTemplates.tmPodTemplate(), (Object)this.KUBERNETES_TM_POD_TEMPLATE());
        return new K8sPodTemplateFiles((scala.collection.immutable.Map<String, String>)podTempleMap.toMap(Predef$.MODULE$.$conforms()));
    }

    private PodTemplateTool$() {
        MODULE$ = this;
        this.KUBERNETES_POD_TEMPLATE = new PodTemplateType("kubernetes.pod-template-file", "pod-template.yaml");
        this.KUBERNETES_JM_POD_TEMPLATE = new PodTemplateType("kubernetes.pod-template-file.jobmanager", "jm-pod-template.yaml");
        this.KUBERNETES_TM_POD_TEMPLATE = new PodTemplateType("kubernetes.pod-template-file.taskmanager", "tm-pod-template.yaml");
    }
}

